/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTransactionsResponse extends ManagedBlockchainQueryResponse implements
        ToCopyableBuilder<ListTransactionsResponse.Builder, ListTransactionsResponse> {
    private static final SdkField<List<TransactionOutputItem>> TRANSACTIONS_FIELD = SdkField
            .<List<TransactionOutputItem>> builder(MarshallingType.LIST)
            .memberName("transactions")
            .getter(getter(ListTransactionsResponse::transactions))
            .setter(setter(Builder::transactions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransactionOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransactionOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTransactionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TransactionOutputItem> transactions;

    private final String nextToken;

    private ListTransactionsResponse(BuilderImpl builder) {
        super(builder);
        this.transactions = builder.transactions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Transactions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransactions() {
        return transactions != null && !(transactions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of transactions returned by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransactions} method.
     * </p>
     * 
     * @return The array of transactions returned by the request.
     */
    public final List<TransactionOutputItem> transactions() {
        return transactions;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransactions() ? transactions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransactionsResponse)) {
            return false;
        }
        ListTransactionsResponse other = (ListTransactionsResponse) obj;
        return hasTransactions() == other.hasTransactions() && Objects.equals(transactions(), other.transactions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTransactionsResponse").add("Transactions", hasTransactions() ? transactions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transactions":
            return Optional.ofNullable(clazz.cast(transactions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transactions", TRANSACTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTransactionsResponse, T> g) {
        return obj -> g.apply((ListTransactionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ManagedBlockchainQueryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTransactionsResponse> {
        /**
         * <p>
         * The array of transactions returned by the request.
         * </p>
         * 
         * @param transactions
         *        The array of transactions returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactions(Collection<TransactionOutputItem> transactions);

        /**
         * <p>
         * The array of transactions returned by the request.
         * </p>
         * 
         * @param transactions
         *        The array of transactions returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactions(TransactionOutputItem... transactions);

        /**
         * <p>
         * The array of transactions returned by the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem.Builder#build()} is
         * called immediately and its result is passed to {@link #transactions(List<TransactionOutputItem>)}.
         * 
         * @param transactions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transactions(java.util.Collection<TransactionOutputItem>)
         */
        Builder transactions(Consumer<TransactionOutputItem.Builder>... transactions);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ManagedBlockchainQueryResponse.BuilderImpl implements Builder {
        private List<TransactionOutputItem> transactions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransactionsResponse model) {
            super(model);
            transactions(model.transactions);
            nextToken(model.nextToken);
        }

        public final List<TransactionOutputItem.Builder> getTransactions() {
            List<TransactionOutputItem.Builder> result = TransactionOutputListCopier.copyToBuilder(this.transactions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransactions(Collection<TransactionOutputItem.BuilderImpl> transactions) {
            this.transactions = TransactionOutputListCopier.copyFromBuilder(transactions);
        }

        @Override
        public final Builder transactions(Collection<TransactionOutputItem> transactions) {
            this.transactions = TransactionOutputListCopier.copy(transactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactions(TransactionOutputItem... transactions) {
            transactions(Arrays.asList(transactions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactions(Consumer<TransactionOutputItem.Builder>... transactions) {
            transactions(Stream.of(transactions).map(c -> TransactionOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTransactionsResponse build() {
            return new ListTransactionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
