/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.AddressIdentifierFilter;
import software.amazon.awssdk.services.managedblockchainquery.model.ConfirmationStatusFilter;
import software.amazon.awssdk.services.managedblockchainquery.model.ListFilteredTransactionEventsSort;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.TimeFilter;
import software.amazon.awssdk.services.managedblockchainquery.model.VoutFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFilteredTransactionEventsRequest
extends ManagedBlockchainQueryRequest
implements ToCopyableBuilder<Builder, ListFilteredTransactionEventsRequest> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("network").getter(ListFilteredTransactionEventsRequest.getter(ListFilteredTransactionEventsRequest::network)).setter(ListFilteredTransactionEventsRequest.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<AddressIdentifierFilter> ADDRESS_IDENTIFIER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("addressIdentifierFilter").getter(ListFilteredTransactionEventsRequest.getter(ListFilteredTransactionEventsRequest::addressIdentifierFilter)).setter(ListFilteredTransactionEventsRequest.setter(Builder::addressIdentifierFilter)).constructor(AddressIdentifierFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressIdentifierFilter").build()}).build();
    private static final SdkField<TimeFilter> TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeFilter").getter(ListFilteredTransactionEventsRequest.getter(ListFilteredTransactionEventsRequest::timeFilter)).setter(ListFilteredTransactionEventsRequest.setter(Builder::timeFilter)).constructor(TimeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeFilter").build()}).build();
    private static final SdkField<VoutFilter> VOUT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("voutFilter").getter(ListFilteredTransactionEventsRequest.getter(ListFilteredTransactionEventsRequest::voutFilter)).setter(ListFilteredTransactionEventsRequest.setter(Builder::voutFilter)).constructor(VoutFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voutFilter").build()}).build();
    private static final SdkField<ConfirmationStatusFilter> CONFIRMATION_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("confirmationStatusFilter").getter(ListFilteredTransactionEventsRequest.getter(ListFilteredTransactionEventsRequest::confirmationStatusFilter)).setter(ListFilteredTransactionEventsRequest.setter(Builder::confirmationStatusFilter)).constructor(ConfirmationStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatusFilter").build()}).build();
    private static final SdkField<ListFilteredTransactionEventsSort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sort").getter(ListFilteredTransactionEventsRequest.getter(ListFilteredTransactionEventsRequest::sort)).setter(ListFilteredTransactionEventsRequest.setter(Builder::sort)).constructor(ListFilteredTransactionEventsSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFilteredTransactionEventsRequest.getter(ListFilteredTransactionEventsRequest::nextToken)).setter(ListFilteredTransactionEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListFilteredTransactionEventsRequest.getter(ListFilteredTransactionEventsRequest::maxResults)).setter(ListFilteredTransactionEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD, ADDRESS_IDENTIFIER_FILTER_FIELD, TIME_FILTER_FIELD, VOUT_FILTER_FIELD, CONFIRMATION_STATUS_FILTER_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("network", NETWORK_FIELD);
            this.put("addressIdentifierFilter", ADDRESS_IDENTIFIER_FILTER_FIELD);
            this.put("timeFilter", TIME_FILTER_FIELD);
            this.put("voutFilter", VOUT_FILTER_FIELD);
            this.put("confirmationStatusFilter", CONFIRMATION_STATUS_FILTER_FIELD);
            this.put("sort", SORT_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String network;
    private final AddressIdentifierFilter addressIdentifierFilter;
    private final TimeFilter timeFilter;
    private final VoutFilter voutFilter;
    private final ConfirmationStatusFilter confirmationStatusFilter;
    private final ListFilteredTransactionEventsSort sort;
    private final String nextToken;
    private final Integer maxResults;

    private ListFilteredTransactionEventsRequest(BuilderImpl builder) {
        super(builder);
        this.network = builder.network;
        this.addressIdentifierFilter = builder.addressIdentifierFilter;
        this.timeFilter = builder.timeFilter;
        this.voutFilter = builder.voutFilter;
        this.confirmationStatusFilter = builder.confirmationStatusFilter;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String network() {
        return this.network;
    }

    public final AddressIdentifierFilter addressIdentifierFilter() {
        return this.addressIdentifierFilter;
    }

    public final TimeFilter timeFilter() {
        return this.timeFilter;
    }

    public final VoutFilter voutFilter() {
        return this.voutFilter;
    }

    public final ConfirmationStatusFilter confirmationStatusFilter() {
        return this.confirmationStatusFilter;
    }

    public final ListFilteredTransactionEventsSort sort() {
        return this.sort;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.network());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressIdentifierFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.voutFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationStatusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFilteredTransactionEventsRequest)) {
            return false;
        }
        ListFilteredTransactionEventsRequest other = (ListFilteredTransactionEventsRequest)((Object)obj);
        return Objects.equals(this.network(), other.network()) && Objects.equals(this.addressIdentifierFilter(), other.addressIdentifierFilter()) && Objects.equals(this.timeFilter(), other.timeFilter()) && Objects.equals(this.voutFilter(), other.voutFilter()) && Objects.equals(this.confirmationStatusFilter(), other.confirmationStatusFilter()) && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListFilteredTransactionEventsRequest").add("Network", (Object)this.network()).add("AddressIdentifierFilter", (Object)this.addressIdentifierFilter()).add("TimeFilter", (Object)this.timeFilter()).add("VoutFilter", (Object)this.voutFilter()).add("ConfirmationStatusFilter", (Object)this.confirmationStatusFilter()).add("Sort", (Object)this.sort()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "network": {
                return Optional.ofNullable(clazz.cast(this.network()));
            }
            case "addressIdentifierFilter": {
                return Optional.ofNullable(clazz.cast(this.addressIdentifierFilter()));
            }
            case "timeFilter": {
                return Optional.ofNullable(clazz.cast(this.timeFilter()));
            }
            case "voutFilter": {
                return Optional.ofNullable(clazz.cast(this.voutFilter()));
            }
            case "confirmationStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.confirmationStatusFilter()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFilteredTransactionEventsRequest, T> g) {
        return obj -> g.apply((ListFilteredTransactionEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryRequest.BuilderImpl
    implements Builder {
        private String network;
        private AddressIdentifierFilter addressIdentifierFilter;
        private TimeFilter timeFilter;
        private VoutFilter voutFilter;
        private ConfirmationStatusFilter confirmationStatusFilter;
        private ListFilteredTransactionEventsSort sort;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFilteredTransactionEventsRequest model) {
            super(model);
            this.network(model.network);
            this.addressIdentifierFilter(model.addressIdentifierFilter);
            this.timeFilter(model.timeFilter);
            this.voutFilter(model.voutFilter);
            this.confirmationStatusFilter(model.confirmationStatusFilter);
            this.sort(model.sort);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        public final AddressIdentifierFilter.Builder getAddressIdentifierFilter() {
            return this.addressIdentifierFilter != null ? this.addressIdentifierFilter.toBuilder() : null;
        }

        public final void setAddressIdentifierFilter(AddressIdentifierFilter.BuilderImpl addressIdentifierFilter) {
            this.addressIdentifierFilter = addressIdentifierFilter != null ? addressIdentifierFilter.build() : null;
        }

        @Override
        public final Builder addressIdentifierFilter(AddressIdentifierFilter addressIdentifierFilter) {
            this.addressIdentifierFilter = addressIdentifierFilter;
            return this;
        }

        public final TimeFilter.Builder getTimeFilter() {
            return this.timeFilter != null ? this.timeFilter.toBuilder() : null;
        }

        public final void setTimeFilter(TimeFilter.BuilderImpl timeFilter) {
            this.timeFilter = timeFilter != null ? timeFilter.build() : null;
        }

        @Override
        public final Builder timeFilter(TimeFilter timeFilter) {
            this.timeFilter = timeFilter;
            return this;
        }

        public final VoutFilter.Builder getVoutFilter() {
            return this.voutFilter != null ? this.voutFilter.toBuilder() : null;
        }

        public final void setVoutFilter(VoutFilter.BuilderImpl voutFilter) {
            this.voutFilter = voutFilter != null ? voutFilter.build() : null;
        }

        @Override
        public final Builder voutFilter(VoutFilter voutFilter) {
            this.voutFilter = voutFilter;
            return this;
        }

        public final ConfirmationStatusFilter.Builder getConfirmationStatusFilter() {
            return this.confirmationStatusFilter != null ? this.confirmationStatusFilter.toBuilder() : null;
        }

        public final void setConfirmationStatusFilter(ConfirmationStatusFilter.BuilderImpl confirmationStatusFilter) {
            this.confirmationStatusFilter = confirmationStatusFilter != null ? confirmationStatusFilter.build() : null;
        }

        @Override
        public final Builder confirmationStatusFilter(ConfirmationStatusFilter confirmationStatusFilter) {
            this.confirmationStatusFilter = confirmationStatusFilter;
            return this;
        }

        public final ListFilteredTransactionEventsSort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(ListFilteredTransactionEventsSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListFilteredTransactionEventsSort sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFilteredTransactionEventsRequest build() {
            return new ListFilteredTransactionEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ManagedBlockchainQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFilteredTransactionEventsRequest> {
        public Builder network(String var1);

        public Builder addressIdentifierFilter(AddressIdentifierFilter var1);

        default public Builder addressIdentifierFilter(Consumer<AddressIdentifierFilter.Builder> addressIdentifierFilter) {
            return this.addressIdentifierFilter((AddressIdentifierFilter)((AddressIdentifierFilter.Builder)AddressIdentifierFilter.builder().applyMutation(addressIdentifierFilter)).build());
        }

        public Builder timeFilter(TimeFilter var1);

        default public Builder timeFilter(Consumer<TimeFilter.Builder> timeFilter) {
            return this.timeFilter((TimeFilter)((TimeFilter.Builder)TimeFilter.builder().applyMutation(timeFilter)).build());
        }

        public Builder voutFilter(VoutFilter var1);

        default public Builder voutFilter(Consumer<VoutFilter.Builder> voutFilter) {
            return this.voutFilter((VoutFilter)((VoutFilter.Builder)VoutFilter.builder().applyMutation(voutFilter)).build());
        }

        public Builder confirmationStatusFilter(ConfirmationStatusFilter var1);

        default public Builder confirmationStatusFilter(Consumer<ConfirmationStatusFilter.Builder> confirmationStatusFilter) {
            return this.confirmationStatusFilter((ConfirmationStatusFilter)((ConfirmationStatusFilter.Builder)ConfirmationStatusFilter.builder().applyMutation(confirmationStatusFilter)).build());
        }

        public Builder sort(ListFilteredTransactionEventsSort var1);

        default public Builder sort(Consumer<ListFilteredTransactionEventsSort.Builder> sort) {
            return this.sort((ListFilteredTransactionEventsSort)((ListFilteredTransactionEventsSort.Builder)ListFilteredTransactionEventsSort.builder().applyMutation(sort)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

