/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainRequest;
import software.amazon.awssdk.services.managedblockchain.model.NodeLogPublishingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNodeRequest
extends ManagedBlockchainRequest
implements ToCopyableBuilder<Builder, UpdateNodeRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkId").getter(UpdateNodeRequest.getter(UpdateNodeRequest::networkId)).setter(UpdateNodeRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberId").getter(UpdateNodeRequest.getter(UpdateNodeRequest::memberId)).setter(UpdateNodeRequest.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(UpdateNodeRequest.getter(UpdateNodeRequest::nodeId)).setter(UpdateNodeRequest.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodeId").build()}).build();
    private static final SdkField<NodeLogPublishingConfiguration> LOG_PUBLISHING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingConfiguration").getter(UpdateNodeRequest.getter(UpdateNodeRequest::logPublishingConfiguration)).setter(UpdateNodeRequest.setter(Builder::logPublishingConfiguration)).constructor(NodeLogPublishingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, MEMBER_ID_FIELD, NODE_ID_FIELD, LOG_PUBLISHING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateNodeRequest.memberNameToFieldInitializer();
    private final String networkId;
    private final String memberId;
    private final String nodeId;
    private final NodeLogPublishingConfiguration logPublishingConfiguration;

    private UpdateNodeRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.memberId = builder.memberId;
        this.nodeId = builder.nodeId;
        this.logPublishingConfiguration = builder.logPublishingConfiguration;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final String memberId() {
        return this.memberId;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final NodeLogPublishingConfiguration logPublishingConfiguration() {
        return this.logPublishingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodeRequest)) {
            return false;
        }
        UpdateNodeRequest other = (UpdateNodeRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.logPublishingConfiguration(), other.logPublishingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNodeRequest").add("NetworkId", (Object)this.networkId()).add("MemberId", (Object)this.memberId()).add("NodeId", (Object)this.nodeId()).add("LogPublishingConfiguration", (Object)this.logPublishingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "LogPublishingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logPublishingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        map.put("nodeId", NODE_ID_FIELD);
        map.put("LogPublishingConfiguration", LOG_PUBLISHING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodeRequest, T> g) {
        return obj -> g.apply((UpdateNodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String memberId;
        private String nodeId;
        private NodeLogPublishingConfiguration logPublishingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodeRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.memberId(model.memberId);
            this.nodeId(model.nodeId);
            this.logPublishingConfiguration(model.logPublishingConfiguration);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getMemberId() {
            return this.memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final NodeLogPublishingConfiguration.Builder getLogPublishingConfiguration() {
            return this.logPublishingConfiguration != null ? this.logPublishingConfiguration.toBuilder() : null;
        }

        public final void setLogPublishingConfiguration(NodeLogPublishingConfiguration.BuilderImpl logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration != null ? logPublishingConfiguration.build() : null;
        }

        @Override
        public final Builder logPublishingConfiguration(NodeLogPublishingConfiguration logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodeRequest build() {
            return new UpdateNodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ManagedBlockchainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNodeRequest> {
        public Builder networkId(String var1);

        public Builder memberId(String var1);

        public Builder nodeId(String var1);

        public Builder logPublishingConfiguration(NodeLogPublishingConfiguration var1);

        default public Builder logPublishingConfiguration(Consumer<NodeLogPublishingConfiguration.Builder> logPublishingConfiguration) {
            return this.logPublishingConfiguration((NodeLogPublishingConfiguration)((NodeLogPublishingConfiguration.Builder)NodeLogPublishingConfiguration.builder().applyMutation(logPublishingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

