/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.managedblockchain.DefaultManagedBlockchainBaseClientBuilder;
import software.amazon.awssdk.services.managedblockchain.DefaultManagedBlockchainClient;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainClient;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainClientBuilder;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainServiceClientConfiguration;
import software.amazon.awssdk.services.managedblockchain.endpoints.ManagedBlockchainEndpointProvider;

@SdkInternalApi
final class DefaultManagedBlockchainClientBuilder
extends DefaultManagedBlockchainBaseClientBuilder<ManagedBlockchainClientBuilder, ManagedBlockchainClient>
implements ManagedBlockchainClientBuilder {
    DefaultManagedBlockchainClientBuilder() {
    }

    @Override
    public DefaultManagedBlockchainClientBuilder endpointProvider(ManagedBlockchainEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ManagedBlockchainClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultManagedBlockchainClientBuilder.validateClientOptions(clientConfiguration);
        ManagedBlockchainServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultManagedBlockchainClient client = new DefaultManagedBlockchainClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ManagedBlockchainServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ManagedBlockchainServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

