/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties for logging events associated with a peer node owned by a member in a Managed Blockchain
 * network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeFabricLogPublishingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeFabricLogPublishingConfiguration.Builder, NodeFabricLogPublishingConfiguration> {
    private static final SdkField<LogConfigurations> CHAINCODE_LOGS_FIELD = SdkField
            .<LogConfigurations> builder(MarshallingType.SDK_POJO).memberName("ChaincodeLogs")
            .getter(getter(NodeFabricLogPublishingConfiguration::chaincodeLogs)).setter(setter(Builder::chaincodeLogs))
            .constructor(LogConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChaincodeLogs").build()).build();

    private static final SdkField<LogConfigurations> PEER_LOGS_FIELD = SdkField
            .<LogConfigurations> builder(MarshallingType.SDK_POJO).memberName("PeerLogs")
            .getter(getter(NodeFabricLogPublishingConfiguration::peerLogs)).setter(setter(Builder::peerLogs))
            .constructor(LogConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAINCODE_LOGS_FIELD,
            PEER_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LogConfigurations chaincodeLogs;

    private final LogConfigurations peerLogs;

    private NodeFabricLogPublishingConfiguration(BuilderImpl builder) {
        this.chaincodeLogs = builder.chaincodeLogs;
        this.peerLogs = builder.peerLogs;
    }

    /**
     * <p>
     * Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode logs
     * contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple instances of
     * chaincode. When enabled, a log stream is created for all chaincodes, with an individual log stream for each
     * chaincode.
     * </p>
     * 
     * @return Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode
     *         logs contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple
     *         instances of chaincode. When enabled, a log stream is created for all chaincodes, with an individual log
     *         stream for each chaincode.
     */
    public final LogConfigurations chaincodeLogs() {
        return chaincodeLogs;
    }

    /**
     * <p>
     * Configuration properties for a peer node log. Peer node logs contain messages generated when your client submits
     * transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists the chaincode
     * instances on a peer node.
     * </p>
     * 
     * @return Configuration properties for a peer node log. Peer node logs contain messages generated when your client
     *         submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists
     *         the chaincode instances on a peer node.
     */
    public final LogConfigurations peerLogs() {
        return peerLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chaincodeLogs());
        hashCode = 31 * hashCode + Objects.hashCode(peerLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeFabricLogPublishingConfiguration)) {
            return false;
        }
        NodeFabricLogPublishingConfiguration other = (NodeFabricLogPublishingConfiguration) obj;
        return Objects.equals(chaincodeLogs(), other.chaincodeLogs()) && Objects.equals(peerLogs(), other.peerLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeFabricLogPublishingConfiguration").add("ChaincodeLogs", chaincodeLogs())
                .add("PeerLogs", peerLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChaincodeLogs":
            return Optional.ofNullable(clazz.cast(chaincodeLogs()));
        case "PeerLogs":
            return Optional.ofNullable(clazz.cast(peerLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeFabricLogPublishingConfiguration, T> g) {
        return obj -> g.apply((NodeFabricLogPublishingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeFabricLogPublishingConfiguration> {
        /**
         * <p>
         * Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode
         * logs contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple
         * instances of chaincode. When enabled, a log stream is created for all chaincodes, with an individual log
         * stream for each chaincode.
         * </p>
         * 
         * @param chaincodeLogs
         *        Configuration properties for logging events associated with chaincode execution on a peer node.
         *        Chaincode logs contain the results of instantiating, invoking, and querying the chaincode. A peer can
         *        run multiple instances of chaincode. When enabled, a log stream is created for all chaincodes, with an
         *        individual log stream for each chaincode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chaincodeLogs(LogConfigurations chaincodeLogs);

        /**
         * <p>
         * Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode
         * logs contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple
         * instances of chaincode. When enabled, a log stream is created for all chaincodes, with an individual log
         * stream for each chaincode.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfigurations.Builder} avoiding the
         * need to create one manually via {@link LogConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfigurations.Builder#build()} is called immediately and its
         * result is passed to {@link #chaincodeLogs(LogConfigurations)}.
         * 
         * @param chaincodeLogs
         *        a consumer that will call methods on {@link LogConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chaincodeLogs(LogConfigurations)
         */
        default Builder chaincodeLogs(Consumer<LogConfigurations.Builder> chaincodeLogs) {
            return chaincodeLogs(LogConfigurations.builder().applyMutation(chaincodeLogs).build());
        }

        /**
         * <p>
         * Configuration properties for a peer node log. Peer node logs contain messages generated when your client
         * submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists the
         * chaincode instances on a peer node.
         * </p>
         * 
         * @param peerLogs
         *        Configuration properties for a peer node log. Peer node logs contain messages generated when your
         *        client submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer,
         *        and lists the chaincode instances on a peer node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerLogs(LogConfigurations peerLogs);

        /**
         * <p>
         * Configuration properties for a peer node log. Peer node logs contain messages generated when your client
         * submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists the
         * chaincode instances on a peer node.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfigurations.Builder} avoiding the
         * need to create one manually via {@link LogConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfigurations.Builder#build()} is called immediately and its
         * result is passed to {@link #peerLogs(LogConfigurations)}.
         * 
         * @param peerLogs
         *        a consumer that will call methods on {@link LogConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #peerLogs(LogConfigurations)
         */
        default Builder peerLogs(Consumer<LogConfigurations.Builder> peerLogs) {
            return peerLogs(LogConfigurations.builder().applyMutation(peerLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LogConfigurations chaincodeLogs;

        private LogConfigurations peerLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeFabricLogPublishingConfiguration model) {
            chaincodeLogs(model.chaincodeLogs);
            peerLogs(model.peerLogs);
        }

        public final LogConfigurations.Builder getChaincodeLogs() {
            return chaincodeLogs != null ? chaincodeLogs.toBuilder() : null;
        }

        public final void setChaincodeLogs(LogConfigurations.BuilderImpl chaincodeLogs) {
            this.chaincodeLogs = chaincodeLogs != null ? chaincodeLogs.build() : null;
        }

        @Override
        public final Builder chaincodeLogs(LogConfigurations chaincodeLogs) {
            this.chaincodeLogs = chaincodeLogs;
            return this;
        }

        public final LogConfigurations.Builder getPeerLogs() {
            return peerLogs != null ? peerLogs.toBuilder() : null;
        }

        public final void setPeerLogs(LogConfigurations.BuilderImpl peerLogs) {
            this.peerLogs = peerLogs != null ? peerLogs.build() : null;
        }

        @Override
        public final Builder peerLogs(LogConfigurations peerLogs) {
            this.peerLogs = peerLogs;
            return this;
        }

        @Override
        public NodeFabricLogPublishingConfiguration build() {
            return new NodeFabricLogPublishingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
