/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties relevant to the network for the blockchain framework that the network uses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFrameworkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFrameworkConfiguration.Builder, NetworkFrameworkConfiguration> {
    private static final SdkField<NetworkFabricConfiguration> FABRIC_FIELD = SdkField
            .<NetworkFabricConfiguration> builder(MarshallingType.SDK_POJO).memberName("Fabric")
            .getter(getter(NetworkFrameworkConfiguration::fabric)).setter(setter(Builder::fabric))
            .constructor(NetworkFabricConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fabric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FABRIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final NetworkFabricConfiguration fabric;

    private NetworkFrameworkConfiguration(BuilderImpl builder) {
        this.fabric = builder.fabric;
    }

    /**
     * <p>
     * Hyperledger Fabric configuration properties for a Managed Blockchain network that uses Hyperledger Fabric.
     * </p>
     * 
     * @return Hyperledger Fabric configuration properties for a Managed Blockchain network that uses Hyperledger
     *         Fabric.
     */
    public final NetworkFabricConfiguration fabric() {
        return fabric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fabric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFrameworkConfiguration)) {
            return false;
        }
        NetworkFrameworkConfiguration other = (NetworkFrameworkConfiguration) obj;
        return Objects.equals(fabric(), other.fabric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFrameworkConfiguration").add("Fabric", fabric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fabric":
            return Optional.ofNullable(clazz.cast(fabric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFrameworkConfiguration, T> g) {
        return obj -> g.apply((NetworkFrameworkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFrameworkConfiguration> {
        /**
         * <p>
         * Hyperledger Fabric configuration properties for a Managed Blockchain network that uses Hyperledger Fabric.
         * </p>
         * 
         * @param fabric
         *        Hyperledger Fabric configuration properties for a Managed Blockchain network that uses Hyperledger
         *        Fabric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fabric(NetworkFabricConfiguration fabric);

        /**
         * <p>
         * Hyperledger Fabric configuration properties for a Managed Blockchain network that uses Hyperledger Fabric.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkFabricConfiguration.Builder}
         * avoiding the need to create one manually via {@link NetworkFabricConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkFabricConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #fabric(NetworkFabricConfiguration)}.
         * 
         * @param fabric
         *        a consumer that will call methods on {@link NetworkFabricConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fabric(NetworkFabricConfiguration)
         */
        default Builder fabric(Consumer<NetworkFabricConfiguration.Builder> fabric) {
            return fabric(NetworkFabricConfiguration.builder().applyMutation(fabric).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NetworkFabricConfiguration fabric;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFrameworkConfiguration model) {
            fabric(model.fabric);
        }

        public final NetworkFabricConfiguration.Builder getFabric() {
            return fabric != null ? fabric.toBuilder() : null;
        }

        public final void setFabric(NetworkFabricConfiguration.BuilderImpl fabric) {
            this.fabric = fabric != null ? fabric.build() : null;
        }

        @Override
        public final Builder fabric(NetworkFabricConfiguration fabric) {
            this.fabric = fabric;
            return this;
        }

        @Override
        public NetworkFrameworkConfiguration build() {
            return new NetworkFrameworkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
