/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainRequest;
import software.amazon.awssdk.services.managedblockchain.model.MemberLogPublishingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMemberRequest
extends ManagedBlockchainRequest
implements ToCopyableBuilder<Builder, UpdateMemberRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkId").getter(UpdateMemberRequest.getter(UpdateMemberRequest::networkId)).setter(UpdateMemberRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberId").getter(UpdateMemberRequest.getter(UpdateMemberRequest::memberId)).setter(UpdateMemberRequest.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memberId").build()}).build();
    private static final SdkField<MemberLogPublishingConfiguration> LOG_PUBLISHING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingConfiguration").getter(UpdateMemberRequest.getter(UpdateMemberRequest::logPublishingConfiguration)).setter(UpdateMemberRequest.setter(Builder::logPublishingConfiguration)).constructor(MemberLogPublishingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, MEMBER_ID_FIELD, LOG_PUBLISHING_CONFIGURATION_FIELD));
    private final String networkId;
    private final String memberId;
    private final MemberLogPublishingConfiguration logPublishingConfiguration;

    private UpdateMemberRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.memberId = builder.memberId;
        this.logPublishingConfiguration = builder.logPublishingConfiguration;
    }

    public String networkId() {
        return this.networkId;
    }

    public String memberId() {
        return this.memberId;
    }

    public MemberLogPublishingConfiguration logPublishingConfiguration() {
        return this.logPublishingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMemberRequest)) {
            return false;
        }
        UpdateMemberRequest other = (UpdateMemberRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.logPublishingConfiguration(), other.logPublishingConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMemberRequest").add("NetworkId", (Object)this.networkId()).add("MemberId", (Object)this.memberId()).add("LogPublishingConfiguration", (Object)this.logPublishingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "LogPublishingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logPublishingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMemberRequest, T> g) {
        return obj -> g.apply((UpdateMemberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String memberId;
        private MemberLogPublishingConfiguration logPublishingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMemberRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.memberId(model.memberId);
            this.logPublishingConfiguration(model.logPublishingConfiguration);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getMemberId() {
            return this.memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public final MemberLogPublishingConfiguration.Builder getLogPublishingConfiguration() {
            return this.logPublishingConfiguration != null ? this.logPublishingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder logPublishingConfiguration(MemberLogPublishingConfiguration logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration;
            return this;
        }

        public final void setLogPublishingConfiguration(MemberLogPublishingConfiguration.BuilderImpl logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration != null ? logPublishingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMemberRequest build() {
            return new UpdateMemberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMemberRequest> {
        public Builder networkId(String var1);

        public Builder memberId(String var1);

        public Builder logPublishingConfiguration(MemberLogPublishingConfiguration var1);

        default public Builder logPublishingConfiguration(Consumer<MemberLogPublishingConfiguration.Builder> logPublishingConfiguration) {
            return this.logPublishingConfiguration((MemberLogPublishingConfiguration)((MemberLogPublishingConfiguration.Builder)MemberLogPublishingConfiguration.builder().applyMutation(logPublishingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

