/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Framework {
    HYPERLEDGER_FABRIC("HYPERLEDGER_FABRIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Framework(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Framework fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Framework.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Framework> knownValues() {
        return Stream.of(Framework.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

