/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainRequest;
import software.amazon.awssdk.services.managedblockchain.model.MemberStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMembersRequest
extends ManagedBlockchainRequest
implements ToCopyableBuilder<Builder, ListMembersRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMembersRequest.getter(ListMembersRequest::networkId)).setter(ListMembersRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMembersRequest.getter(ListMembersRequest::name)).setter(ListMembersRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMembersRequest.getter(ListMembersRequest::statusAsString)).setter(ListMembersRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<Boolean> IS_OWNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListMembersRequest.getter(ListMembersRequest::isOwned)).setter(ListMembersRequest.setter(Builder::isOwned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isOwned").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListMembersRequest.getter(ListMembersRequest::maxResults)).setter(ListMembersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListMembersRequest.getter(ListMembersRequest::nextToken)).setter(ListMembersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, NAME_FIELD, STATUS_FIELD, IS_OWNED_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String networkId;
    private final String name;
    private final String status;
    private final Boolean isOwned;
    private final Integer maxResults;
    private final String nextToken;

    private ListMembersRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.name = builder.name;
        this.status = builder.status;
        this.isOwned = builder.isOwned;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String networkId() {
        return this.networkId;
    }

    public String name() {
        return this.name;
    }

    public MemberStatus status() {
        return MemberStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Boolean isOwned() {
        return this.isOwned;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isOwned());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersRequest)) {
            return false;
        }
        ListMembersRequest other = (ListMembersRequest)((Object)obj);
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.isOwned(), other.isOwned()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMembersRequest").add("NetworkId", (Object)this.networkId()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("IsOwned", (Object)this.isOwned()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "IsOwned": {
                return Optional.ofNullable(clazz.cast(this.isOwned()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMembersRequest, T> g) {
        return obj -> g.apply((ListMembersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainRequest.BuilderImpl
    implements Builder {
        private String networkId;
        private String name;
        private String status;
        private Boolean isOwned;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersRequest model) {
            super(model);
            this.networkId(model.networkId);
            this.name(model.name);
            this.status(model.status);
            this.isOwned(model.isOwned);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getIsOwned() {
            return this.isOwned;
        }

        @Override
        public final Builder isOwned(Boolean isOwned) {
            this.isOwned = isOwned;
            return this;
        }

        public final void setIsOwned(Boolean isOwned) {
            this.isOwned = isOwned;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMembersRequest build() {
            return new ListMembersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMembersRequest> {
        public Builder networkId(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(MemberStatus var1);

        public Builder isOwned(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

