/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes of Hyperledger Fabric for a member in a Managed Blockchain network using the Hyperledger Fabric framework.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberFabricAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberFabricAttributes.Builder, MemberFabricAttributes> {
    private static final SdkField<String> ADMIN_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MemberFabricAttributes::adminUsername)).setter(setter(Builder::adminUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminUsername").build()).build();

    private static final SdkField<String> CA_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MemberFabricAttributes::caEndpoint)).setter(setter(Builder::caEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USERNAME_FIELD,
            CA_ENDPOINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adminUsername;

    private final String caEndpoint;

    private MemberFabricAttributes(BuilderImpl builder) {
        this.adminUsername = builder.adminUsername;
        this.caEndpoint = builder.caEndpoint;
    }

    /**
     * <p>
     * The user name for the initial administrator user for the member.
     * </p>
     * 
     * @return The user name for the initial administrator user for the member.
     */
    public String adminUsername() {
        return adminUsername;
    }

    /**
     * <p>
     * The endpoint used to access the member's certificate authority.
     * </p>
     * 
     * @return The endpoint used to access the member's certificate authority.
     */
    public String caEndpoint() {
        return caEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adminUsername());
        hashCode = 31 * hashCode + Objects.hashCode(caEndpoint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberFabricAttributes)) {
            return false;
        }
        MemberFabricAttributes other = (MemberFabricAttributes) obj;
        return Objects.equals(adminUsername(), other.adminUsername()) && Objects.equals(caEndpoint(), other.caEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MemberFabricAttributes").add("AdminUsername", adminUsername()).add("CaEndpoint", caEndpoint())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminUsername":
            return Optional.ofNullable(clazz.cast(adminUsername()));
        case "CaEndpoint":
            return Optional.ofNullable(clazz.cast(caEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberFabricAttributes, T> g) {
        return obj -> g.apply((MemberFabricAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberFabricAttributes> {
        /**
         * <p>
         * The user name for the initial administrator user for the member.
         * </p>
         * 
         * @param adminUsername
         *        The user name for the initial administrator user for the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUsername(String adminUsername);

        /**
         * <p>
         * The endpoint used to access the member's certificate authority.
         * </p>
         * 
         * @param caEndpoint
         *        The endpoint used to access the member's certificate authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caEndpoint(String caEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String adminUsername;

        private String caEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberFabricAttributes model) {
            adminUsername(model.adminUsername);
            caEndpoint(model.caEndpoint);
        }

        public final String getAdminUsername() {
            return adminUsername;
        }

        @Override
        public final Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public final void setAdminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
        }

        public final String getCaEndpoint() {
            return caEndpoint;
        }

        @Override
        public final Builder caEndpoint(String caEndpoint) {
            this.caEndpoint = caEndpoint;
            return this;
        }

        public final void setCaEndpoint(String caEndpoint) {
            this.caEndpoint = caEndpoint;
        }

        @Override
        public MemberFabricAttributes build() {
            return new MemberFabricAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
