/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ArchiveFilters;
import software.amazon.awssdk.services.mailmanager.model.ExportDestinationConfiguration;
import software.amazon.awssdk.services.mailmanager.model.ExportStatus;
import software.amazon.awssdk.services.mailmanager.model.MailManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetArchiveExportResponse
extends MailManagerResponse
implements ToCopyableBuilder<Builder, GetArchiveExportResponse> {
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveId").getter(GetArchiveExportResponse.getter(GetArchiveExportResponse::archiveId)).setter(GetArchiveExportResponse.setter(Builder::archiveId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()}).build();
    private static final SdkField<ExportDestinationConfiguration> EXPORT_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportDestinationConfiguration").getter(GetArchiveExportResponse.getter(GetArchiveExportResponse::exportDestinationConfiguration)).setter(GetArchiveExportResponse.setter(Builder::exportDestinationConfiguration)).constructor(ExportDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDestinationConfiguration").build()}).build();
    private static final SdkField<ArchiveFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(GetArchiveExportResponse.getter(GetArchiveExportResponse::filters)).setter(GetArchiveExportResponse.setter(Builder::filters)).constructor(ArchiveFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<Instant> FROM_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FromTimestamp").getter(GetArchiveExportResponse.getter(GetArchiveExportResponse::fromTimestamp)).setter(GetArchiveExportResponse.setter(Builder::fromTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromTimestamp").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetArchiveExportResponse.getter(GetArchiveExportResponse::maxResults)).setter(GetArchiveExportResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<ExportStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(GetArchiveExportResponse.getter(GetArchiveExportResponse::status)).setter(GetArchiveExportResponse.setter(Builder::status)).constructor(ExportStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> TO_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ToTimestamp").getter(GetArchiveExportResponse.getter(GetArchiveExportResponse::toTimestamp)).setter(GetArchiveExportResponse.setter(Builder::toTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ID_FIELD, EXPORT_DESTINATION_CONFIGURATION_FIELD, FILTERS_FIELD, FROM_TIMESTAMP_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD, TO_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetArchiveExportResponse.memberNameToFieldInitializer();
    private final String archiveId;
    private final ExportDestinationConfiguration exportDestinationConfiguration;
    private final ArchiveFilters filters;
    private final Instant fromTimestamp;
    private final Integer maxResults;
    private final ExportStatus status;
    private final Instant toTimestamp;

    private GetArchiveExportResponse(BuilderImpl builder) {
        super(builder);
        this.archiveId = builder.archiveId;
        this.exportDestinationConfiguration = builder.exportDestinationConfiguration;
        this.filters = builder.filters;
        this.fromTimestamp = builder.fromTimestamp;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
        this.toTimestamp = builder.toTimestamp;
    }

    public final String archiveId() {
        return this.archiveId;
    }

    public final ExportDestinationConfiguration exportDestinationConfiguration() {
        return this.exportDestinationConfiguration;
    }

    public final ArchiveFilters filters() {
        return this.filters;
    }

    public final Instant fromTimestamp() {
        return this.fromTimestamp;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ExportStatus status() {
        return this.status;
    }

    public final Instant toTimestamp() {
        return this.toTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.toTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveExportResponse)) {
            return false;
        }
        GetArchiveExportResponse other = (GetArchiveExportResponse)((Object)obj);
        return Objects.equals(this.archiveId(), other.archiveId()) && Objects.equals(this.exportDestinationConfiguration(), other.exportDestinationConfiguration()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.fromTimestamp(), other.fromTimestamp()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.toTimestamp(), other.toTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetArchiveExportResponse").add("ArchiveId", (Object)this.archiveId()).add("ExportDestinationConfiguration", (Object)this.exportDestinationConfiguration()).add("Filters", (Object)this.filters()).add("FromTimestamp", (Object)this.fromTimestamp()).add("MaxResults", (Object)this.maxResults()).add("Status", (Object)this.status()).add("ToTimestamp", (Object)this.toTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveId": {
                return Optional.ofNullable(clazz.cast(this.archiveId()));
            }
            case "ExportDestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.exportDestinationConfiguration()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "FromTimestamp": {
                return Optional.ofNullable(clazz.cast(this.fromTimestamp()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ToTimestamp": {
                return Optional.ofNullable(clazz.cast(this.toTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArchiveId", ARCHIVE_ID_FIELD);
        map.put("ExportDestinationConfiguration", EXPORT_DESTINATION_CONFIGURATION_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("FromTimestamp", FROM_TIMESTAMP_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ToTimestamp", TO_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveExportResponse, T> g) {
        return obj -> g.apply((GetArchiveExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MailManagerResponse.BuilderImpl
    implements Builder {
        private String archiveId;
        private ExportDestinationConfiguration exportDestinationConfiguration;
        private ArchiveFilters filters;
        private Instant fromTimestamp;
        private Integer maxResults;
        private ExportStatus status;
        private Instant toTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveExportResponse model) {
            super(model);
            this.archiveId(model.archiveId);
            this.exportDestinationConfiguration(model.exportDestinationConfiguration);
            this.filters(model.filters);
            this.fromTimestamp(model.fromTimestamp);
            this.maxResults(model.maxResults);
            this.status(model.status);
            this.toTimestamp(model.toTimestamp);
        }

        public final String getArchiveId() {
            return this.archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final ExportDestinationConfiguration.Builder getExportDestinationConfiguration() {
            return this.exportDestinationConfiguration != null ? this.exportDestinationConfiguration.toBuilder() : null;
        }

        public final void setExportDestinationConfiguration(ExportDestinationConfiguration.BuilderImpl exportDestinationConfiguration) {
            this.exportDestinationConfiguration = exportDestinationConfiguration != null ? exportDestinationConfiguration.build() : null;
        }

        @Override
        public final Builder exportDestinationConfiguration(ExportDestinationConfiguration exportDestinationConfiguration) {
            this.exportDestinationConfiguration = exportDestinationConfiguration;
            return this;
        }

        public final ArchiveFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(ArchiveFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ArchiveFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Instant getFromTimestamp() {
            return this.fromTimestamp;
        }

        public final void setFromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
        }

        @Override
        public final Builder fromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ExportStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ExportStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ExportStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getToTimestamp() {
            return this.toTimestamp;
        }

        public final void setToTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
        }

        @Override
        public final Builder toTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        @Override
        public GetArchiveExportResponse build() {
            return new GetArchiveExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MailManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetArchiveExportResponse> {
        public Builder archiveId(String var1);

        public Builder exportDestinationConfiguration(ExportDestinationConfiguration var1);

        default public Builder exportDestinationConfiguration(Consumer<ExportDestinationConfiguration.Builder> exportDestinationConfiguration) {
            return this.exportDestinationConfiguration((ExportDestinationConfiguration)((ExportDestinationConfiguration.Builder)ExportDestinationConfiguration.builder().applyMutation(exportDestinationConfiguration)).build());
        }

        public Builder filters(ArchiveFilters var1);

        default public Builder filters(Consumer<ArchiveFilters.Builder> filters) {
            return this.filters((ArchiveFilters)((ArchiveFilters.Builder)ArchiveFilters.builder().applyMutation(filters)).build());
        }

        public Builder fromTimestamp(Instant var1);

        public Builder maxResults(Integer var1);

        public Builder status(ExportStatus var1);

        default public Builder status(Consumer<ExportStatus.Builder> status) {
            return this.status((ExportStatus)((ExportStatus.Builder)ExportStatus.builder().applyMutation(status)).build());
        }

        public Builder toTimestamp(Instant var1);
    }
}

