/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mailmanager.model.AddHeaderAction;
import software.amazon.awssdk.services.mailmanager.model.ArchiveAction;
import software.amazon.awssdk.services.mailmanager.model.DeliverToMailboxAction;
import software.amazon.awssdk.services.mailmanager.model.DeliverToQBusinessAction;
import software.amazon.awssdk.services.mailmanager.model.DropAction;
import software.amazon.awssdk.services.mailmanager.model.RelayAction;
import software.amazon.awssdk.services.mailmanager.model.ReplaceRecipientAction;
import software.amazon.awssdk.services.mailmanager.model.S3Action;
import software.amazon.awssdk.services.mailmanager.model.SendAction;
import software.amazon.awssdk.services.mailmanager.model.SnsAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleAction> {
    private static final SdkField<AddHeaderAction> ADD_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AddHeader").getter(RuleAction.getter(RuleAction::addHeader)).setter(RuleAction.setter(Builder::addHeader)).constructor(AddHeaderAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddHeader").build()}).build();
    private static final SdkField<ArchiveAction> ARCHIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Archive").getter(RuleAction.getter(RuleAction::archive)).setter(RuleAction.setter(Builder::archive)).constructor(ArchiveAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Archive").build()}).build();
    private static final SdkField<DeliverToMailboxAction> DELIVER_TO_MAILBOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliverToMailbox").getter(RuleAction.getter(RuleAction::deliverToMailbox)).setter(RuleAction.setter(Builder::deliverToMailbox)).constructor(DeliverToMailboxAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverToMailbox").build()}).build();
    private static final SdkField<DeliverToQBusinessAction> DELIVER_TO_Q_BUSINESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliverToQBusiness").getter(RuleAction.getter(RuleAction::deliverToQBusiness)).setter(RuleAction.setter(Builder::deliverToQBusiness)).constructor(DeliverToQBusinessAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverToQBusiness").build()}).build();
    private static final SdkField<DropAction> DROP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Drop").getter(RuleAction.getter(RuleAction::drop)).setter(RuleAction.setter(Builder::drop)).constructor(DropAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Drop").build()}).build();
    private static final SdkField<SnsAction> PUBLISH_TO_SNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublishToSns").getter(RuleAction.getter(RuleAction::publishToSns)).setter(RuleAction.setter(Builder::publishToSns)).constructor(SnsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishToSns").build()}).build();
    private static final SdkField<RelayAction> RELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Relay").getter(RuleAction.getter(RuleAction::relay)).setter(RuleAction.setter(Builder::relay)).constructor(RelayAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relay").build()}).build();
    private static final SdkField<ReplaceRecipientAction> REPLACE_RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplaceRecipient").getter(RuleAction.getter(RuleAction::replaceRecipient)).setter(RuleAction.setter(Builder::replaceRecipient)).constructor(ReplaceRecipientAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceRecipient").build()}).build();
    private static final SdkField<SendAction> SEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Send").getter(RuleAction.getter(RuleAction::send)).setter(RuleAction.setter(Builder::send)).constructor(SendAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Send").build()}).build();
    private static final SdkField<S3Action> WRITE_TO_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WriteToS3").getter(RuleAction.getter(RuleAction::writeToS3)).setter(RuleAction.setter(Builder::writeToS3)).constructor(S3Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteToS3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_HEADER_FIELD, ARCHIVE_FIELD, DELIVER_TO_MAILBOX_FIELD, DELIVER_TO_Q_BUSINESS_FIELD, DROP_FIELD, PUBLISH_TO_SNS_FIELD, RELAY_FIELD, REPLACE_RECIPIENT_FIELD, SEND_FIELD, WRITE_TO_S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AddHeaderAction addHeader;
    private final ArchiveAction archive;
    private final DeliverToMailboxAction deliverToMailbox;
    private final DeliverToQBusinessAction deliverToQBusiness;
    private final DropAction drop;
    private final SnsAction publishToSns;
    private final RelayAction relay;
    private final ReplaceRecipientAction replaceRecipient;
    private final SendAction send;
    private final S3Action writeToS3;
    private final Type type;

    private RuleAction(BuilderImpl builder) {
        this.addHeader = builder.addHeader;
        this.archive = builder.archive;
        this.deliverToMailbox = builder.deliverToMailbox;
        this.deliverToQBusiness = builder.deliverToQBusiness;
        this.drop = builder.drop;
        this.publishToSns = builder.publishToSns;
        this.relay = builder.relay;
        this.replaceRecipient = builder.replaceRecipient;
        this.send = builder.send;
        this.writeToS3 = builder.writeToS3;
        this.type = builder.type;
    }

    public final AddHeaderAction addHeader() {
        return this.addHeader;
    }

    public final ArchiveAction archive() {
        return this.archive;
    }

    public final DeliverToMailboxAction deliverToMailbox() {
        return this.deliverToMailbox;
    }

    public final DeliverToQBusinessAction deliverToQBusiness() {
        return this.deliverToQBusiness;
    }

    public final DropAction drop() {
        return this.drop;
    }

    public final SnsAction publishToSns() {
        return this.publishToSns;
    }

    public final RelayAction relay() {
        return this.relay;
    }

    public final ReplaceRecipientAction replaceRecipient() {
        return this.replaceRecipient;
    }

    public final SendAction send() {
        return this.send;
    }

    public final S3Action writeToS3() {
        return this.writeToS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.archive());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverToMailbox());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverToQBusiness());
        hashCode = 31 * hashCode + Objects.hashCode(this.drop());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishToSns());
        hashCode = 31 * hashCode + Objects.hashCode(this.relay());
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceRecipient());
        hashCode = 31 * hashCode + Objects.hashCode(this.send());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeToS3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleAction)) {
            return false;
        }
        RuleAction other = (RuleAction)obj;
        return Objects.equals(this.addHeader(), other.addHeader()) && Objects.equals(this.archive(), other.archive()) && Objects.equals(this.deliverToMailbox(), other.deliverToMailbox()) && Objects.equals(this.deliverToQBusiness(), other.deliverToQBusiness()) && Objects.equals(this.drop(), other.drop()) && Objects.equals(this.publishToSns(), other.publishToSns()) && Objects.equals(this.relay(), other.relay()) && Objects.equals(this.replaceRecipient(), other.replaceRecipient()) && Objects.equals(this.send(), other.send()) && Objects.equals(this.writeToS3(), other.writeToS3());
    }

    public final String toString() {
        return ToString.builder((String)"RuleAction").add("AddHeader", (Object)this.addHeader()).add("Archive", (Object)this.archive()).add("DeliverToMailbox", (Object)this.deliverToMailbox()).add("DeliverToQBusiness", (Object)this.deliverToQBusiness()).add("Drop", (Object)this.drop()).add("PublishToSns", (Object)this.publishToSns()).add("Relay", (Object)this.relay()).add("ReplaceRecipient", (Object)this.replaceRecipient()).add("Send", (Object)this.send()).add("WriteToS3", (Object)this.writeToS3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddHeader": {
                return Optional.ofNullable(clazz.cast(this.addHeader()));
            }
            case "Archive": {
                return Optional.ofNullable(clazz.cast(this.archive()));
            }
            case "DeliverToMailbox": {
                return Optional.ofNullable(clazz.cast(this.deliverToMailbox()));
            }
            case "DeliverToQBusiness": {
                return Optional.ofNullable(clazz.cast(this.deliverToQBusiness()));
            }
            case "Drop": {
                return Optional.ofNullable(clazz.cast(this.drop()));
            }
            case "PublishToSns": {
                return Optional.ofNullable(clazz.cast(this.publishToSns()));
            }
            case "Relay": {
                return Optional.ofNullable(clazz.cast(this.relay()));
            }
            case "ReplaceRecipient": {
                return Optional.ofNullable(clazz.cast(this.replaceRecipient()));
            }
            case "Send": {
                return Optional.ofNullable(clazz.cast(this.send()));
            }
            case "WriteToS3": {
                return Optional.ofNullable(clazz.cast(this.writeToS3()));
            }
        }
        return Optional.empty();
    }

    public static RuleAction fromAddHeader(AddHeaderAction addHeader) {
        return (RuleAction)RuleAction.builder().addHeader(addHeader).build();
    }

    public static RuleAction fromAddHeader(Consumer<AddHeaderAction.Builder> addHeader) {
        AddHeaderAction.Builder builder = AddHeaderAction.builder();
        addHeader.accept(builder);
        return RuleAction.fromAddHeader((AddHeaderAction)builder.build());
    }

    public static RuleAction fromArchive(ArchiveAction archive) {
        return (RuleAction)RuleAction.builder().archive(archive).build();
    }

    public static RuleAction fromArchive(Consumer<ArchiveAction.Builder> archive) {
        ArchiveAction.Builder builder = ArchiveAction.builder();
        archive.accept(builder);
        return RuleAction.fromArchive((ArchiveAction)builder.build());
    }

    public static RuleAction fromDeliverToMailbox(DeliverToMailboxAction deliverToMailbox) {
        return (RuleAction)RuleAction.builder().deliverToMailbox(deliverToMailbox).build();
    }

    public static RuleAction fromDeliverToMailbox(Consumer<DeliverToMailboxAction.Builder> deliverToMailbox) {
        DeliverToMailboxAction.Builder builder = DeliverToMailboxAction.builder();
        deliverToMailbox.accept(builder);
        return RuleAction.fromDeliverToMailbox((DeliverToMailboxAction)builder.build());
    }

    public static RuleAction fromDeliverToQBusiness(DeliverToQBusinessAction deliverToQBusiness) {
        return (RuleAction)RuleAction.builder().deliverToQBusiness(deliverToQBusiness).build();
    }

    public static RuleAction fromDeliverToQBusiness(Consumer<DeliverToQBusinessAction.Builder> deliverToQBusiness) {
        DeliverToQBusinessAction.Builder builder = DeliverToQBusinessAction.builder();
        deliverToQBusiness.accept(builder);
        return RuleAction.fromDeliverToQBusiness((DeliverToQBusinessAction)builder.build());
    }

    public static RuleAction fromDrop(DropAction drop) {
        return (RuleAction)RuleAction.builder().drop(drop).build();
    }

    public static RuleAction fromDrop(Consumer<DropAction.Builder> drop) {
        DropAction.Builder builder = DropAction.builder();
        drop.accept(builder);
        return RuleAction.fromDrop((DropAction)builder.build());
    }

    public static RuleAction fromPublishToSns(SnsAction publishToSns) {
        return (RuleAction)RuleAction.builder().publishToSns(publishToSns).build();
    }

    public static RuleAction fromPublishToSns(Consumer<SnsAction.Builder> publishToSns) {
        SnsAction.Builder builder = SnsAction.builder();
        publishToSns.accept(builder);
        return RuleAction.fromPublishToSns((SnsAction)builder.build());
    }

    public static RuleAction fromRelay(RelayAction relay) {
        return (RuleAction)RuleAction.builder().relay(relay).build();
    }

    public static RuleAction fromRelay(Consumer<RelayAction.Builder> relay) {
        RelayAction.Builder builder = RelayAction.builder();
        relay.accept(builder);
        return RuleAction.fromRelay((RelayAction)builder.build());
    }

    public static RuleAction fromReplaceRecipient(ReplaceRecipientAction replaceRecipient) {
        return (RuleAction)RuleAction.builder().replaceRecipient(replaceRecipient).build();
    }

    public static RuleAction fromReplaceRecipient(Consumer<ReplaceRecipientAction.Builder> replaceRecipient) {
        ReplaceRecipientAction.Builder builder = ReplaceRecipientAction.builder();
        replaceRecipient.accept(builder);
        return RuleAction.fromReplaceRecipient((ReplaceRecipientAction)builder.build());
    }

    public static RuleAction fromSend(SendAction send) {
        return (RuleAction)RuleAction.builder().send(send).build();
    }

    public static RuleAction fromSend(Consumer<SendAction.Builder> send) {
        SendAction.Builder builder = SendAction.builder();
        send.accept(builder);
        return RuleAction.fromSend((SendAction)builder.build());
    }

    public static RuleAction fromWriteToS3(S3Action writeToS3) {
        return (RuleAction)RuleAction.builder().writeToS3(writeToS3).build();
    }

    public static RuleAction fromWriteToS3(Consumer<S3Action.Builder> writeToS3) {
        S3Action.Builder builder = S3Action.builder();
        writeToS3.accept(builder);
        return RuleAction.fromWriteToS3((S3Action)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddHeader", ADD_HEADER_FIELD);
        map.put("Archive", ARCHIVE_FIELD);
        map.put("DeliverToMailbox", DELIVER_TO_MAILBOX_FIELD);
        map.put("DeliverToQBusiness", DELIVER_TO_Q_BUSINESS_FIELD);
        map.put("Drop", DROP_FIELD);
        map.put("PublishToSns", PUBLISH_TO_SNS_FIELD);
        map.put("Relay", RELAY_FIELD);
        map.put("ReplaceRecipient", REPLACE_RECIPIENT_FIELD);
        map.put("Send", SEND_FIELD);
        map.put("WriteToS3", WRITE_TO_S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleAction, T> g) {
        return obj -> g.apply((RuleAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ADD_HEADER,
        ARCHIVE,
        DELIVER_TO_MAILBOX,
        DELIVER_TO_Q_BUSINESS,
        DROP,
        PUBLISH_TO_SNS,
        RELAY,
        REPLACE_RECIPIENT,
        SEND,
        WRITE_TO_S3,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AddHeaderAction addHeader;
        private ArchiveAction archive;
        private DeliverToMailboxAction deliverToMailbox;
        private DeliverToQBusinessAction deliverToQBusiness;
        private DropAction drop;
        private SnsAction publishToSns;
        private RelayAction relay;
        private ReplaceRecipientAction replaceRecipient;
        private SendAction send;
        private S3Action writeToS3;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleAction model) {
            this.addHeader(model.addHeader);
            this.archive(model.archive);
            this.deliverToMailbox(model.deliverToMailbox);
            this.deliverToQBusiness(model.deliverToQBusiness);
            this.drop(model.drop);
            this.publishToSns(model.publishToSns);
            this.relay(model.relay);
            this.replaceRecipient(model.replaceRecipient);
            this.send(model.send);
            this.writeToS3(model.writeToS3);
        }

        public final AddHeaderAction.Builder getAddHeader() {
            return this.addHeader != null ? this.addHeader.toBuilder() : null;
        }

        public final void setAddHeader(AddHeaderAction.BuilderImpl addHeader) {
            AddHeaderAction oldValue = this.addHeader;
            this.addHeader = addHeader != null ? addHeader.build() : null;
            this.handleUnionValueChange(Type.ADD_HEADER, oldValue, this.addHeader);
        }

        @Override
        public final Builder addHeader(AddHeaderAction addHeader) {
            AddHeaderAction oldValue = this.addHeader;
            this.addHeader = addHeader;
            this.handleUnionValueChange(Type.ADD_HEADER, oldValue, this.addHeader);
            return this;
        }

        public final ArchiveAction.Builder getArchive() {
            return this.archive != null ? this.archive.toBuilder() : null;
        }

        public final void setArchive(ArchiveAction.BuilderImpl archive) {
            ArchiveAction oldValue = this.archive;
            this.archive = archive != null ? archive.build() : null;
            this.handleUnionValueChange(Type.ARCHIVE, oldValue, this.archive);
        }

        @Override
        public final Builder archive(ArchiveAction archive) {
            ArchiveAction oldValue = this.archive;
            this.archive = archive;
            this.handleUnionValueChange(Type.ARCHIVE, oldValue, this.archive);
            return this;
        }

        public final DeliverToMailboxAction.Builder getDeliverToMailbox() {
            return this.deliverToMailbox != null ? this.deliverToMailbox.toBuilder() : null;
        }

        public final void setDeliverToMailbox(DeliverToMailboxAction.BuilderImpl deliverToMailbox) {
            DeliverToMailboxAction oldValue = this.deliverToMailbox;
            this.deliverToMailbox = deliverToMailbox != null ? deliverToMailbox.build() : null;
            this.handleUnionValueChange(Type.DELIVER_TO_MAILBOX, oldValue, this.deliverToMailbox);
        }

        @Override
        public final Builder deliverToMailbox(DeliverToMailboxAction deliverToMailbox) {
            DeliverToMailboxAction oldValue = this.deliverToMailbox;
            this.deliverToMailbox = deliverToMailbox;
            this.handleUnionValueChange(Type.DELIVER_TO_MAILBOX, oldValue, this.deliverToMailbox);
            return this;
        }

        public final DeliverToQBusinessAction.Builder getDeliverToQBusiness() {
            return this.deliverToQBusiness != null ? this.deliverToQBusiness.toBuilder() : null;
        }

        public final void setDeliverToQBusiness(DeliverToQBusinessAction.BuilderImpl deliverToQBusiness) {
            DeliverToQBusinessAction oldValue = this.deliverToQBusiness;
            this.deliverToQBusiness = deliverToQBusiness != null ? deliverToQBusiness.build() : null;
            this.handleUnionValueChange(Type.DELIVER_TO_Q_BUSINESS, oldValue, this.deliverToQBusiness);
        }

        @Override
        public final Builder deliverToQBusiness(DeliverToQBusinessAction deliverToQBusiness) {
            DeliverToQBusinessAction oldValue = this.deliverToQBusiness;
            this.deliverToQBusiness = deliverToQBusiness;
            this.handleUnionValueChange(Type.DELIVER_TO_Q_BUSINESS, oldValue, this.deliverToQBusiness);
            return this;
        }

        public final DropAction.Builder getDrop() {
            return this.drop != null ? this.drop.toBuilder() : null;
        }

        public final void setDrop(DropAction.BuilderImpl drop) {
            DropAction oldValue = this.drop;
            this.drop = drop != null ? drop.build() : null;
            this.handleUnionValueChange(Type.DROP, oldValue, this.drop);
        }

        @Override
        public final Builder drop(DropAction drop) {
            DropAction oldValue = this.drop;
            this.drop = drop;
            this.handleUnionValueChange(Type.DROP, oldValue, this.drop);
            return this;
        }

        public final SnsAction.Builder getPublishToSns() {
            return this.publishToSns != null ? this.publishToSns.toBuilder() : null;
        }

        public final void setPublishToSns(SnsAction.BuilderImpl publishToSns) {
            SnsAction oldValue = this.publishToSns;
            this.publishToSns = publishToSns != null ? publishToSns.build() : null;
            this.handleUnionValueChange(Type.PUBLISH_TO_SNS, oldValue, this.publishToSns);
        }

        @Override
        public final Builder publishToSns(SnsAction publishToSns) {
            SnsAction oldValue = this.publishToSns;
            this.publishToSns = publishToSns;
            this.handleUnionValueChange(Type.PUBLISH_TO_SNS, oldValue, this.publishToSns);
            return this;
        }

        public final RelayAction.Builder getRelay() {
            return this.relay != null ? this.relay.toBuilder() : null;
        }

        public final void setRelay(RelayAction.BuilderImpl relay) {
            RelayAction oldValue = this.relay;
            this.relay = relay != null ? relay.build() : null;
            this.handleUnionValueChange(Type.RELAY, oldValue, this.relay);
        }

        @Override
        public final Builder relay(RelayAction relay) {
            RelayAction oldValue = this.relay;
            this.relay = relay;
            this.handleUnionValueChange(Type.RELAY, oldValue, this.relay);
            return this;
        }

        public final ReplaceRecipientAction.Builder getReplaceRecipient() {
            return this.replaceRecipient != null ? this.replaceRecipient.toBuilder() : null;
        }

        public final void setReplaceRecipient(ReplaceRecipientAction.BuilderImpl replaceRecipient) {
            ReplaceRecipientAction oldValue = this.replaceRecipient;
            this.replaceRecipient = replaceRecipient != null ? replaceRecipient.build() : null;
            this.handleUnionValueChange(Type.REPLACE_RECIPIENT, oldValue, this.replaceRecipient);
        }

        @Override
        public final Builder replaceRecipient(ReplaceRecipientAction replaceRecipient) {
            ReplaceRecipientAction oldValue = this.replaceRecipient;
            this.replaceRecipient = replaceRecipient;
            this.handleUnionValueChange(Type.REPLACE_RECIPIENT, oldValue, this.replaceRecipient);
            return this;
        }

        public final SendAction.Builder getSend() {
            return this.send != null ? this.send.toBuilder() : null;
        }

        public final void setSend(SendAction.BuilderImpl send) {
            SendAction oldValue = this.send;
            this.send = send != null ? send.build() : null;
            this.handleUnionValueChange(Type.SEND, oldValue, this.send);
        }

        @Override
        public final Builder send(SendAction send) {
            SendAction oldValue = this.send;
            this.send = send;
            this.handleUnionValueChange(Type.SEND, oldValue, this.send);
            return this;
        }

        public final S3Action.Builder getWriteToS3() {
            return this.writeToS3 != null ? this.writeToS3.toBuilder() : null;
        }

        public final void setWriteToS3(S3Action.BuilderImpl writeToS3) {
            S3Action oldValue = this.writeToS3;
            this.writeToS3 = writeToS3 != null ? writeToS3.build() : null;
            this.handleUnionValueChange(Type.WRITE_TO_S3, oldValue, this.writeToS3);
        }

        @Override
        public final Builder writeToS3(S3Action writeToS3) {
            S3Action oldValue = this.writeToS3;
            this.writeToS3 = writeToS3;
            this.handleUnionValueChange(Type.WRITE_TO_S3, oldValue, this.writeToS3);
            return this;
        }

        public RuleAction build() {
            return new RuleAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleAction> {
        public Builder addHeader(AddHeaderAction var1);

        default public Builder addHeader(Consumer<AddHeaderAction.Builder> addHeader) {
            return this.addHeader((AddHeaderAction)((AddHeaderAction.Builder)AddHeaderAction.builder().applyMutation(addHeader)).build());
        }

        public Builder archive(ArchiveAction var1);

        default public Builder archive(Consumer<ArchiveAction.Builder> archive) {
            return this.archive((ArchiveAction)((ArchiveAction.Builder)ArchiveAction.builder().applyMutation(archive)).build());
        }

        public Builder deliverToMailbox(DeliverToMailboxAction var1);

        default public Builder deliverToMailbox(Consumer<DeliverToMailboxAction.Builder> deliverToMailbox) {
            return this.deliverToMailbox((DeliverToMailboxAction)((DeliverToMailboxAction.Builder)DeliverToMailboxAction.builder().applyMutation(deliverToMailbox)).build());
        }

        public Builder deliverToQBusiness(DeliverToQBusinessAction var1);

        default public Builder deliverToQBusiness(Consumer<DeliverToQBusinessAction.Builder> deliverToQBusiness) {
            return this.deliverToQBusiness((DeliverToQBusinessAction)((DeliverToQBusinessAction.Builder)DeliverToQBusinessAction.builder().applyMutation(deliverToQBusiness)).build());
        }

        public Builder drop(DropAction var1);

        default public Builder drop(Consumer<DropAction.Builder> drop) {
            return this.drop((DropAction)((DropAction.Builder)DropAction.builder().applyMutation(drop)).build());
        }

        public Builder publishToSns(SnsAction var1);

        default public Builder publishToSns(Consumer<SnsAction.Builder> publishToSns) {
            return this.publishToSns((SnsAction)((SnsAction.Builder)SnsAction.builder().applyMutation(publishToSns)).build());
        }

        public Builder relay(RelayAction var1);

        default public Builder relay(Consumer<RelayAction.Builder> relay) {
            return this.relay((RelayAction)((RelayAction.Builder)RelayAction.builder().applyMutation(relay)).build());
        }

        public Builder replaceRecipient(ReplaceRecipientAction var1);

        default public Builder replaceRecipient(Consumer<ReplaceRecipientAction.Builder> replaceRecipient) {
            return this.replaceRecipient((ReplaceRecipientAction)((ReplaceRecipientAction.Builder)ReplaceRecipientAction.builder().applyMutation(replaceRecipient)).build());
        }

        public Builder send(SendAction var1);

        default public Builder send(Consumer<SendAction.Builder> send) {
            return this.send((SendAction)((SendAction.Builder)SendAction.builder().applyMutation(send)).build());
        }

        public Builder writeToS3(S3Action var1);

        default public Builder writeToS3(Consumer<S3Action.Builder> writeToS3) {
            return this.writeToS3((S3Action)((S3Action.Builder)S3Action.builder().applyMutation(writeToS3)).build());
        }
    }
}

