/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.EmailReceivedHeadersListCopier;
import software.amazon.awssdk.services.mailmanager.model.Envelope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Row
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Row> {
    private static final SdkField<String> ARCHIVED_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchivedMessageId").getter(Row.getter(Row::archivedMessageId)).setter(Row.setter(Builder::archivedMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivedMessageId").build()}).build();
    private static final SdkField<String> CC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cc").getter(Row.getter(Row::cc)).setter(Row.setter(Builder::cc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cc").build()}).build();
    private static final SdkField<String> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Date").getter(Row.getter(Row::date)).setter(Row.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()}).build();
    private static final SdkField<Envelope> ENVELOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Envelope").getter(Row.getter(Row::envelope)).setter(Row.setter(Builder::envelope)).constructor(Envelope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Envelope").build()}).build();
    private static final SdkField<String> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("From").getter(Row.getter(Row::from)).setter(Row.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()}).build();
    private static final SdkField<Boolean> HAS_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasAttachments").getter(Row.getter(Row::hasAttachments)).setter(Row.setter(Builder::hasAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasAttachments").build()}).build();
    private static final SdkField<String> IN_REPLY_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InReplyTo").getter(Row.getter(Row::inReplyTo)).setter(Row.setter(Builder::inReplyTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InReplyTo").build()}).build();
    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngressPointId").getter(Row.getter(Row::ingressPointId)).setter(Row.setter(Builder::ingressPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(Row.getter(Row::messageId)).setter(Row.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<List<String>> RECEIVED_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReceivedHeaders").getter(Row.getter(Row::receivedHeaders)).setter(Row.setter(Builder::receivedHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> RECEIVED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReceivedTimestamp").getter(Row.getter(Row::receivedTimestamp)).setter(Row.setter(Builder::receivedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedTimestamp").build()}).build();
    private static final SdkField<String> SENDER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderHostname").getter(Row.getter(Row::senderHostname)).setter(Row.setter(Builder::senderHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderHostname").build()}).build();
    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderIpAddress").getter(Row.getter(Row::senderIpAddress)).setter(Row.setter(Builder::senderIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderIpAddress").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(Row.getter(Row::sourceArn)).setter(Row.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(Row.getter(Row::subject)).setter(Row.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("To").getter(Row.getter(Row::to)).setter(Row.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()}).build();
    private static final SdkField<String> X_MAILER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XMailer").getter(Row.getter(Row::xMailer)).setter(Row.setter(Builder::xMailer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XMailer").build()}).build();
    private static final SdkField<String> X_ORIGINAL_MAILER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XOriginalMailer").getter(Row.getter(Row::xOriginalMailer)).setter(Row.setter(Builder::xOriginalMailer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XOriginalMailer").build()}).build();
    private static final SdkField<String> X_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XPriority").getter(Row.getter(Row::xPriority)).setter(Row.setter(Builder::xPriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XPriority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVED_MESSAGE_ID_FIELD, CC_FIELD, DATE_FIELD, ENVELOPE_FIELD, FROM_FIELD, HAS_ATTACHMENTS_FIELD, IN_REPLY_TO_FIELD, INGRESS_POINT_ID_FIELD, MESSAGE_ID_FIELD, RECEIVED_HEADERS_FIELD, RECEIVED_TIMESTAMP_FIELD, SENDER_HOSTNAME_FIELD, SENDER_IP_ADDRESS_FIELD, SOURCE_ARN_FIELD, SUBJECT_FIELD, TO_FIELD, X_MAILER_FIELD, X_ORIGINAL_MAILER_FIELD, X_PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Row.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String archivedMessageId;
    private final String cc;
    private final String date;
    private final Envelope envelope;
    private final String from;
    private final Boolean hasAttachments;
    private final String inReplyTo;
    private final String ingressPointId;
    private final String messageId;
    private final List<String> receivedHeaders;
    private final Instant receivedTimestamp;
    private final String senderHostname;
    private final String senderIpAddress;
    private final String sourceArn;
    private final String subject;
    private final String to;
    private final String xMailer;
    private final String xOriginalMailer;
    private final String xPriority;

    private Row(BuilderImpl builder) {
        this.archivedMessageId = builder.archivedMessageId;
        this.cc = builder.cc;
        this.date = builder.date;
        this.envelope = builder.envelope;
        this.from = builder.from;
        this.hasAttachments = builder.hasAttachments;
        this.inReplyTo = builder.inReplyTo;
        this.ingressPointId = builder.ingressPointId;
        this.messageId = builder.messageId;
        this.receivedHeaders = builder.receivedHeaders;
        this.receivedTimestamp = builder.receivedTimestamp;
        this.senderHostname = builder.senderHostname;
        this.senderIpAddress = builder.senderIpAddress;
        this.sourceArn = builder.sourceArn;
        this.subject = builder.subject;
        this.to = builder.to;
        this.xMailer = builder.xMailer;
        this.xOriginalMailer = builder.xOriginalMailer;
        this.xPriority = builder.xPriority;
    }

    public final String archivedMessageId() {
        return this.archivedMessageId;
    }

    public final String cc() {
        return this.cc;
    }

    public final String date() {
        return this.date;
    }

    public final Envelope envelope() {
        return this.envelope;
    }

    public final String from() {
        return this.from;
    }

    public final Boolean hasAttachments() {
        return this.hasAttachments;
    }

    public final String inReplyTo() {
        return this.inReplyTo;
    }

    public final String ingressPointId() {
        return this.ingressPointId;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final boolean hasReceivedHeaders() {
        return this.receivedHeaders != null && !(this.receivedHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> receivedHeaders() {
        return this.receivedHeaders;
    }

    public final Instant receivedTimestamp() {
        return this.receivedTimestamp;
    }

    public final String senderHostname() {
        return this.senderHostname;
    }

    public final String senderIpAddress() {
        return this.senderIpAddress;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String subject() {
        return this.subject;
    }

    public final String to() {
        return this.to;
    }

    public final String xMailer() {
        return this.xMailer;
    }

    public final String xOriginalMailer() {
        return this.xOriginalMailer;
    }

    public final String xPriority() {
        return this.xPriority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archivedMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cc());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.envelope());
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.inReplyTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReceivedHeaders() ? this.receivedHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.receivedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        hashCode = 31 * hashCode + Objects.hashCode(this.xMailer());
        hashCode = 31 * hashCode + Objects.hashCode(this.xOriginalMailer());
        hashCode = 31 * hashCode + Objects.hashCode(this.xPriority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row)obj;
        return Objects.equals(this.archivedMessageId(), other.archivedMessageId()) && Objects.equals(this.cc(), other.cc()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.envelope(), other.envelope()) && Objects.equals(this.from(), other.from()) && Objects.equals(this.hasAttachments(), other.hasAttachments()) && Objects.equals(this.inReplyTo(), other.inReplyTo()) && Objects.equals(this.ingressPointId(), other.ingressPointId()) && Objects.equals(this.messageId(), other.messageId()) && this.hasReceivedHeaders() == other.hasReceivedHeaders() && Objects.equals(this.receivedHeaders(), other.receivedHeaders()) && Objects.equals(this.receivedTimestamp(), other.receivedTimestamp()) && Objects.equals(this.senderHostname(), other.senderHostname()) && Objects.equals(this.senderIpAddress(), other.senderIpAddress()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.to(), other.to()) && Objects.equals(this.xMailer(), other.xMailer()) && Objects.equals(this.xOriginalMailer(), other.xOriginalMailer()) && Objects.equals(this.xPriority(), other.xPriority());
    }

    public final String toString() {
        return ToString.builder((String)"Row").add("ArchivedMessageId", (Object)this.archivedMessageId()).add("Cc", (Object)this.cc()).add("Date", (Object)this.date()).add("Envelope", (Object)this.envelope()).add("From", (Object)this.from()).add("HasAttachments", (Object)this.hasAttachments()).add("InReplyTo", (Object)this.inReplyTo()).add("IngressPointId", (Object)this.ingressPointId()).add("MessageId", (Object)this.messageId()).add("ReceivedHeaders", this.hasReceivedHeaders() ? this.receivedHeaders() : null).add("ReceivedTimestamp", (Object)this.receivedTimestamp()).add("SenderHostname", (Object)this.senderHostname()).add("SenderIpAddress", (Object)(this.senderIpAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("SourceArn", (Object)this.sourceArn()).add("Subject", (Object)this.subject()).add("To", (Object)this.to()).add("XMailer", (Object)this.xMailer()).add("XOriginalMailer", (Object)this.xOriginalMailer()).add("XPriority", (Object)this.xPriority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchivedMessageId": {
                return Optional.ofNullable(clazz.cast(this.archivedMessageId()));
            }
            case "Cc": {
                return Optional.ofNullable(clazz.cast(this.cc()));
            }
            case "Date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "Envelope": {
                return Optional.ofNullable(clazz.cast(this.envelope()));
            }
            case "From": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "HasAttachments": {
                return Optional.ofNullable(clazz.cast(this.hasAttachments()));
            }
            case "InReplyTo": {
                return Optional.ofNullable(clazz.cast(this.inReplyTo()));
            }
            case "IngressPointId": {
                return Optional.ofNullable(clazz.cast(this.ingressPointId()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "ReceivedHeaders": {
                return Optional.ofNullable(clazz.cast(this.receivedHeaders()));
            }
            case "ReceivedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.receivedTimestamp()));
            }
            case "SenderHostname": {
                return Optional.ofNullable(clazz.cast(this.senderHostname()));
            }
            case "SenderIpAddress": {
                return Optional.ofNullable(clazz.cast(this.senderIpAddress()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "To": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
            case "XMailer": {
                return Optional.ofNullable(clazz.cast(this.xMailer()));
            }
            case "XOriginalMailer": {
                return Optional.ofNullable(clazz.cast(this.xOriginalMailer()));
            }
            case "XPriority": {
                return Optional.ofNullable(clazz.cast(this.xPriority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArchivedMessageId", ARCHIVED_MESSAGE_ID_FIELD);
        map.put("Cc", CC_FIELD);
        map.put("Date", DATE_FIELD);
        map.put("Envelope", ENVELOPE_FIELD);
        map.put("From", FROM_FIELD);
        map.put("HasAttachments", HAS_ATTACHMENTS_FIELD);
        map.put("InReplyTo", IN_REPLY_TO_FIELD);
        map.put("IngressPointId", INGRESS_POINT_ID_FIELD);
        map.put("MessageId", MESSAGE_ID_FIELD);
        map.put("ReceivedHeaders", RECEIVED_HEADERS_FIELD);
        map.put("ReceivedTimestamp", RECEIVED_TIMESTAMP_FIELD);
        map.put("SenderHostname", SENDER_HOSTNAME_FIELD);
        map.put("SenderIpAddress", SENDER_IP_ADDRESS_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("To", TO_FIELD);
        map.put("XMailer", X_MAILER_FIELD);
        map.put("XOriginalMailer", X_ORIGINAL_MAILER_FIELD);
        map.put("XPriority", X_PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Row, T> g) {
        return obj -> g.apply((Row)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String archivedMessageId;
        private String cc;
        private String date;
        private Envelope envelope;
        private String from;
        private Boolean hasAttachments;
        private String inReplyTo;
        private String ingressPointId;
        private String messageId;
        private List<String> receivedHeaders = DefaultSdkAutoConstructList.getInstance();
        private Instant receivedTimestamp;
        private String senderHostname;
        private String senderIpAddress;
        private String sourceArn;
        private String subject;
        private String to;
        private String xMailer;
        private String xOriginalMailer;
        private String xPriority;

        private BuilderImpl() {
        }

        private BuilderImpl(Row model) {
            this.archivedMessageId(model.archivedMessageId);
            this.cc(model.cc);
            this.date(model.date);
            this.envelope(model.envelope);
            this.from(model.from);
            this.hasAttachments(model.hasAttachments);
            this.inReplyTo(model.inReplyTo);
            this.ingressPointId(model.ingressPointId);
            this.messageId(model.messageId);
            this.receivedHeaders(model.receivedHeaders);
            this.receivedTimestamp(model.receivedTimestamp);
            this.senderHostname(model.senderHostname);
            this.senderIpAddress(model.senderIpAddress);
            this.sourceArn(model.sourceArn);
            this.subject(model.subject);
            this.to(model.to);
            this.xMailer(model.xMailer);
            this.xOriginalMailer(model.xOriginalMailer);
            this.xPriority(model.xPriority);
        }

        public final String getArchivedMessageId() {
            return this.archivedMessageId;
        }

        public final void setArchivedMessageId(String archivedMessageId) {
            this.archivedMessageId = archivedMessageId;
        }

        @Override
        public final Builder archivedMessageId(String archivedMessageId) {
            this.archivedMessageId = archivedMessageId;
            return this;
        }

        public final String getCc() {
            return this.cc;
        }

        public final void setCc(String cc) {
            this.cc = cc;
        }

        @Override
        public final Builder cc(String cc) {
            this.cc = cc;
            return this;
        }

        public final String getDate() {
            return this.date;
        }

        public final void setDate(String date) {
            this.date = date;
        }

        @Override
        public final Builder date(String date) {
            this.date = date;
            return this;
        }

        public final Envelope.Builder getEnvelope() {
            return this.envelope != null ? this.envelope.toBuilder() : null;
        }

        public final void setEnvelope(Envelope.BuilderImpl envelope) {
            this.envelope = envelope != null ? envelope.build() : null;
        }

        @Override
        public final Builder envelope(Envelope envelope) {
            this.envelope = envelope;
            return this;
        }

        public final String getFrom() {
            return this.from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final Boolean getHasAttachments() {
            return this.hasAttachments;
        }

        public final void setHasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
        }

        @Override
        public final Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            return this;
        }

        public final String getInReplyTo() {
            return this.inReplyTo;
        }

        public final void setInReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
        }

        @Override
        public final Builder inReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public final String getIngressPointId() {
            return this.ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Collection<String> getReceivedHeaders() {
            if (this.receivedHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.receivedHeaders;
        }

        public final void setReceivedHeaders(Collection<String> receivedHeaders) {
            this.receivedHeaders = EmailReceivedHeadersListCopier.copy(receivedHeaders);
        }

        @Override
        public final Builder receivedHeaders(Collection<String> receivedHeaders) {
            this.receivedHeaders = EmailReceivedHeadersListCopier.copy(receivedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receivedHeaders(String ... receivedHeaders) {
            this.receivedHeaders(Arrays.asList(receivedHeaders));
            return this;
        }

        public final Instant getReceivedTimestamp() {
            return this.receivedTimestamp;
        }

        public final void setReceivedTimestamp(Instant receivedTimestamp) {
            this.receivedTimestamp = receivedTimestamp;
        }

        @Override
        public final Builder receivedTimestamp(Instant receivedTimestamp) {
            this.receivedTimestamp = receivedTimestamp;
            return this;
        }

        public final String getSenderHostname() {
            return this.senderHostname;
        }

        public final void setSenderHostname(String senderHostname) {
            this.senderHostname = senderHostname;
        }

        @Override
        public final Builder senderHostname(String senderHostname) {
            this.senderHostname = senderHostname;
            return this;
        }

        public final String getSenderIpAddress() {
            return this.senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getTo() {
            return this.to;
        }

        public final void setTo(String to) {
            this.to = to;
        }

        @Override
        public final Builder to(String to) {
            this.to = to;
            return this;
        }

        public final String getXMailer() {
            return this.xMailer;
        }

        public final void setXMailer(String xMailer) {
            this.xMailer = xMailer;
        }

        @Override
        public final Builder xMailer(String xMailer) {
            this.xMailer = xMailer;
            return this;
        }

        public final String getXOriginalMailer() {
            return this.xOriginalMailer;
        }

        public final void setXOriginalMailer(String xOriginalMailer) {
            this.xOriginalMailer = xOriginalMailer;
        }

        @Override
        public final Builder xOriginalMailer(String xOriginalMailer) {
            this.xOriginalMailer = xOriginalMailer;
            return this;
        }

        public final String getXPriority() {
            return this.xPriority;
        }

        public final void setXPriority(String xPriority) {
            this.xPriority = xPriority;
        }

        @Override
        public final Builder xPriority(String xPriority) {
            this.xPriority = xPriority;
            return this;
        }

        public Row build() {
            return new Row(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Row> {
        public Builder archivedMessageId(String var1);

        public Builder cc(String var1);

        public Builder date(String var1);

        public Builder envelope(Envelope var1);

        default public Builder envelope(Consumer<Envelope.Builder> envelope) {
            return this.envelope((Envelope)((Envelope.Builder)Envelope.builder().applyMutation(envelope)).build());
        }

        public Builder from(String var1);

        public Builder hasAttachments(Boolean var1);

        public Builder inReplyTo(String var1);

        public Builder ingressPointId(String var1);

        public Builder messageId(String var1);

        public Builder receivedHeaders(Collection<String> var1);

        public Builder receivedHeaders(String ... var1);

        public Builder receivedTimestamp(Instant var1);

        public Builder senderHostname(String var1);

        public Builder senderIpAddress(String var1);

        public Builder sourceArn(String var1);

        public Builder subject(String var1);

        public Builder to(String var1);

        public Builder xMailer(String var1);

        public Builder xOriginalMailer(String var1);

        public Builder xPriority(String var1);
    }
}

