/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.RuleDmarcOperator;
import software.amazon.awssdk.services.mailmanager.model.RuleDmarcPolicy;
import software.amazon.awssdk.services.mailmanager.model.RuleDmarcValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleDmarcExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleDmarcExpression> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(RuleDmarcExpression.getter(RuleDmarcExpression::operatorAsString)).setter(RuleDmarcExpression.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(RuleDmarcExpression.getter(RuleDmarcExpression::valuesAsStrings)).setter(RuleDmarcExpression.setter(Builder::valuesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Operator", OPERATOR_FIELD);
            this.put("Values", VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String operator;
    private final List<String> values;

    private RuleDmarcExpression(BuilderImpl builder) {
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public final RuleDmarcOperator operator() {
        return RuleDmarcOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final List<RuleDmarcPolicy> values() {
        return RuleDmarcValueListCopier.copyStringToEnum(this.values);
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> valuesAsStrings() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.valuesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDmarcExpression)) {
            return false;
        }
        RuleDmarcExpression other = (RuleDmarcExpression)obj;
        return Objects.equals(this.operatorAsString(), other.operatorAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.valuesAsStrings(), other.valuesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RuleDmarcExpression").add("Operator", (Object)this.operatorAsString()).add("Values", this.hasValues() ? this.valuesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.valuesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RuleDmarcExpression, T> g) {
        return obj -> g.apply((RuleDmarcExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operator;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleDmarcExpression model) {
            this.operator(model.operator);
            this.valuesWithStrings(model.values);
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleDmarcOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = RuleDmarcValueListCopier.copy(values);
        }

        @Override
        public final Builder valuesWithStrings(Collection<String> values) {
            this.values = RuleDmarcValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesWithStrings(String ... values) {
            this.valuesWithStrings(Arrays.asList(values));
            return this;
        }

        @Override
        public final Builder values(Collection<RuleDmarcPolicy> values) {
            this.values = RuleDmarcValueListCopier.copyEnumToString(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(RuleDmarcPolicy ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public RuleDmarcExpression build() {
            return new RuleDmarcExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleDmarcExpression> {
        public Builder operator(String var1);

        public Builder operator(RuleDmarcOperator var1);

        public Builder valuesWithStrings(Collection<String> var1);

        public Builder valuesWithStrings(String ... var1);

        public Builder values(Collection<RuleDmarcPolicy> var1);

        public Builder values(RuleDmarcPolicy ... var1);
    }
}

