/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ExportSummary;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveExportsResponse;

public class ListArchiveExportsPublisher
implements SdkPublisher<ListArchiveExportsResponse> {
    private final MailManagerAsyncClient client;
    private final ListArchiveExportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListArchiveExportsPublisher(MailManagerAsyncClient client, ListArchiveExportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListArchiveExportsPublisher(MailManagerAsyncClient client, ListArchiveExportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListArchiveExportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListArchiveExportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExportSummary> exports() {
        Function<ListArchiveExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exports() != null) {
                return response.exports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListArchiveExportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListArchiveExportsResponseFetcher
    implements AsyncPageFetcher<ListArchiveExportsResponse> {
        private ListArchiveExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListArchiveExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListArchiveExportsResponse> nextPage(ListArchiveExportsResponse previousPage) {
            if (previousPage == null) {
                return ListArchiveExportsPublisher.this.client.listArchiveExports(ListArchiveExportsPublisher.this.firstRequest);
            }
            return ListArchiveExportsPublisher.this.client.listArchiveExports((ListArchiveExportsRequest)((Object)ListArchiveExportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

