/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchiveSearchesResponse;
import software.amazon.awssdk.services.mailmanager.model.SearchSummary;

public class ListArchiveSearchesPublisher
implements SdkPublisher<ListArchiveSearchesResponse> {
    private final MailManagerAsyncClient client;
    private final ListArchiveSearchesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListArchiveSearchesPublisher(MailManagerAsyncClient client, ListArchiveSearchesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListArchiveSearchesPublisher(MailManagerAsyncClient client, ListArchiveSearchesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListArchiveSearchesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListArchiveSearchesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SearchSummary> searches() {
        Function<ListArchiveSearchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.searches() != null) {
                return response.searches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListArchiveSearchesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListArchiveSearchesResponseFetcher
    implements AsyncPageFetcher<ListArchiveSearchesResponse> {
        private ListArchiveSearchesResponseFetcher() {
        }

        public boolean hasNextPage(ListArchiveSearchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListArchiveSearchesResponse> nextPage(ListArchiveSearchesResponse previousPage) {
            if (previousPage == null) {
                return ListArchiveSearchesPublisher.this.client.listArchiveSearches(ListArchiveSearchesPublisher.this.firstRequest);
            }
            return ListArchiveSearchesPublisher.this.client.listArchiveSearches((ListArchiveSearchesRequest)((Object)ListArchiveSearchesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

