/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.RuleIpOperator;
import software.amazon.awssdk.services.mailmanager.model.RuleIpToEvaluate;
import software.amazon.awssdk.services.mailmanager.model.RuleIpValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleIpExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleIpExpression> {
    private static final SdkField<RuleIpToEvaluate> EVALUATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Evaluate").getter(RuleIpExpression.getter(RuleIpExpression::evaluate)).setter(RuleIpExpression.setter(Builder::evaluate)).constructor(RuleIpToEvaluate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(RuleIpExpression.getter(RuleIpExpression::operatorAsString)).setter(RuleIpExpression.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(RuleIpExpression.getter(RuleIpExpression::values)).setter(RuleIpExpression.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATE_FIELD, OPERATOR_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Evaluate", EVALUATE_FIELD);
            this.put("Operator", OPERATOR_FIELD);
            this.put("Values", VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RuleIpToEvaluate evaluate;
    private final String operator;
    private final List<String> values;

    private RuleIpExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public final RuleIpToEvaluate evaluate() {
        return this.evaluate;
    }

    public final RuleIpOperator operator() {
        return RuleIpOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleIpExpression)) {
            return false;
        }
        RuleIpExpression other = (RuleIpExpression)obj;
        return Objects.equals(this.evaluate(), other.evaluate()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"RuleIpExpression").add("Evaluate", (Object)this.evaluate()).add("Operator", (Object)this.operatorAsString()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Evaluate": {
                return Optional.ofNullable(clazz.cast(this.evaluate()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RuleIpExpression, T> g) {
        return obj -> g.apply((RuleIpExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RuleIpToEvaluate evaluate;
        private String operator;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleIpExpression model) {
            this.evaluate(model.evaluate);
            this.operator(model.operator);
            this.values(model.values);
        }

        public final RuleIpToEvaluate.Builder getEvaluate() {
            return this.evaluate != null ? this.evaluate.toBuilder() : null;
        }

        public final void setEvaluate(RuleIpToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(RuleIpToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleIpOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = RuleIpValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = RuleIpValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public RuleIpExpression build() {
            return new RuleIpExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleIpExpression> {
        public Builder evaluate(RuleIpToEvaluate var1);

        default public Builder evaluate(Consumer<RuleIpToEvaluate.Builder> evaluate) {
            return this.evaluate((RuleIpToEvaluate)((RuleIpToEvaluate.Builder)RuleIpToEvaluate.builder().applyMutation(evaluate)).build());
        }

        public Builder operator(String var1);

        public Builder operator(RuleIpOperator var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

