/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.ActionFailurePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Action> {
    private static final SdkField<String> ACTION_FAILURE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionFailurePolicy").getter(S3Action.getter(S3Action::actionFailurePolicyAsString)).setter(S3Action.setter(Builder::actionFailurePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionFailurePolicy").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(S3Action.getter(S3Action::roleArn)).setter(S3Action.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(S3Action.getter(S3Action::s3Bucket)).setter(S3Action.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(S3Action.getter(S3Action::s3Prefix)).setter(S3Action.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()}).build();
    private static final SdkField<String> S3_SSE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3SseKmsKeyId").getter(S3Action.getter(S3Action::s3SseKmsKeyId)).setter(S3Action.setter(Builder::s3SseKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseKmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FAILURE_POLICY_FIELD, ROLE_ARN_FIELD, S3_BUCKET_FIELD, S3_PREFIX_FIELD, S3_SSE_KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ActionFailurePolicy", ACTION_FAILURE_POLICY_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("S3Bucket", S3_BUCKET_FIELD);
            this.put("S3Prefix", S3_PREFIX_FIELD);
            this.put("S3SseKmsKeyId", S3_SSE_KMS_KEY_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String actionFailurePolicy;
    private final String roleArn;
    private final String s3Bucket;
    private final String s3Prefix;
    private final String s3SseKmsKeyId;

    private S3Action(BuilderImpl builder) {
        this.actionFailurePolicy = builder.actionFailurePolicy;
        this.roleArn = builder.roleArn;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.s3SseKmsKeyId = builder.s3SseKmsKeyId;
    }

    public final ActionFailurePolicy actionFailurePolicy() {
        return ActionFailurePolicy.fromValue(this.actionFailurePolicy);
    }

    public final String actionFailurePolicyAsString() {
        return this.actionFailurePolicy;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final String s3SseKmsKeyId() {
        return this.s3SseKmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionFailurePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3SseKmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action)obj;
        return Objects.equals(this.actionFailurePolicyAsString(), other.actionFailurePolicyAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.s3SseKmsKeyId(), other.s3SseKmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"S3Action").add("ActionFailurePolicy", (Object)this.actionFailurePolicyAsString()).add("RoleArn", (Object)this.roleArn()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Prefix", (Object)this.s3Prefix()).add("S3SseKmsKeyId", (Object)this.s3SseKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionFailurePolicy": {
                return Optional.ofNullable(clazz.cast(this.actionFailurePolicyAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "S3SseKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.s3SseKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3Action, T> g) {
        return obj -> g.apply((S3Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionFailurePolicy;
        private String roleArn;
        private String s3Bucket;
        private String s3Prefix;
        private String s3SseKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            this.actionFailurePolicy(model.actionFailurePolicy);
            this.roleArn(model.roleArn);
            this.s3Bucket(model.s3Bucket);
            this.s3Prefix(model.s3Prefix);
            this.s3SseKmsKeyId(model.s3SseKmsKeyId);
        }

        public final String getActionFailurePolicy() {
            return this.actionFailurePolicy;
        }

        public final void setActionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
        }

        @Override
        public final Builder actionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
            return this;
        }

        @Override
        public final Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy) {
            this.actionFailurePolicy(actionFailurePolicy == null ? null : actionFailurePolicy.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3SseKmsKeyId() {
            return this.s3SseKmsKeyId;
        }

        public final void setS3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
        }

        @Override
        public final Builder s3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
            return this;
        }

        public S3Action build() {
            return new S3Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Action> {
        public Builder actionFailurePolicy(String var1);

        public Builder actionFailurePolicy(ActionFailurePolicy var1);

        public Builder roleArn(String var1);

        public Builder s3Bucket(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3SseKmsKeyId(String var1);
    }
}

