/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry;
import software.amazon.awssdk.services.macie2.model.___listOfSensitivityInspectionTemplatesEntryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSensitivityInspectionTemplatesResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, ListSensitivityInspectionTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSensitivityInspectionTemplatesResponse.getter(ListSensitivityInspectionTemplatesResponse::nextToken)).setter(ListSensitivityInspectionTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SensitivityInspectionTemplatesEntry>> SENSITIVITY_INSPECTION_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sensitivityInspectionTemplates").getter(ListSensitivityInspectionTemplatesResponse.getter(ListSensitivityInspectionTemplatesResponse::sensitivityInspectionTemplates)).setter(ListSensitivityInspectionTemplatesResponse.setter(Builder::sensitivityInspectionTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityInspectionTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SensitivityInspectionTemplatesEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SENSITIVITY_INSPECTION_TEMPLATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSensitivityInspectionTemplatesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates;

    private ListSensitivityInspectionTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sensitivityInspectionTemplates = builder.sensitivityInspectionTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSensitivityInspectionTemplates() {
        return this.sensitivityInspectionTemplates != null && !(this.sensitivityInspectionTemplates instanceof SdkAutoConstructList);
    }

    public final List<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates() {
        return this.sensitivityInspectionTemplates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSensitivityInspectionTemplates() ? this.sensitivityInspectionTemplates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSensitivityInspectionTemplatesResponse)) {
            return false;
        }
        ListSensitivityInspectionTemplatesResponse other = (ListSensitivityInspectionTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSensitivityInspectionTemplates() == other.hasSensitivityInspectionTemplates() && Objects.equals(this.sensitivityInspectionTemplates(), other.sensitivityInspectionTemplates());
    }

    public final String toString() {
        return ToString.builder((String)"ListSensitivityInspectionTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("SensitivityInspectionTemplates", this.hasSensitivityInspectionTemplates() ? this.sensitivityInspectionTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sensitivityInspectionTemplates": {
                return Optional.ofNullable(clazz.cast(this.sensitivityInspectionTemplates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sensitivityInspectionTemplates", SENSITIVITY_INSPECTION_TEMPLATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSensitivityInspectionTemplatesResponse, T> g) {
        return obj -> g.apply((ListSensitivityInspectionTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSensitivityInspectionTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sensitivityInspectionTemplates(model.sensitivityInspectionTemplates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SensitivityInspectionTemplatesEntry.Builder> getSensitivityInspectionTemplates() {
            List<SensitivityInspectionTemplatesEntry.Builder> result = ___listOfSensitivityInspectionTemplatesEntryCopier.copyToBuilder(this.sensitivityInspectionTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSensitivityInspectionTemplates(Collection<SensitivityInspectionTemplatesEntry.BuilderImpl> sensitivityInspectionTemplates) {
            this.sensitivityInspectionTemplates = ___listOfSensitivityInspectionTemplatesEntryCopier.copyFromBuilder(sensitivityInspectionTemplates);
        }

        @Override
        public final Builder sensitivityInspectionTemplates(Collection<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates) {
            this.sensitivityInspectionTemplates = ___listOfSensitivityInspectionTemplatesEntryCopier.copy(sensitivityInspectionTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitivityInspectionTemplates(SensitivityInspectionTemplatesEntry ... sensitivityInspectionTemplates) {
            this.sensitivityInspectionTemplates(Arrays.asList(sensitivityInspectionTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitivityInspectionTemplates(Consumer<SensitivityInspectionTemplatesEntry.Builder> ... sensitivityInspectionTemplates) {
            this.sensitivityInspectionTemplates(Stream.of(sensitivityInspectionTemplates).map(c -> (SensitivityInspectionTemplatesEntry)((SensitivityInspectionTemplatesEntry.Builder)SensitivityInspectionTemplatesEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSensitivityInspectionTemplatesResponse build() {
            return new ListSensitivityInspectionTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSensitivityInspectionTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder sensitivityInspectionTemplates(Collection<SensitivityInspectionTemplatesEntry> var1);

        public Builder sensitivityInspectionTemplates(SensitivityInspectionTemplatesEntry ... var1);

        public Builder sensitivityInspectionTemplates(Consumer<SensitivityInspectionTemplatesEntry.Builder> ... var1);
    }
}

