/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.RetrievalConfiguration;
import software.amazon.awssdk.services.macie2.model.RevealConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRevealConfigurationResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, UpdateRevealConfigurationResponse> {
    private static final SdkField<RevealConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateRevealConfigurationResponse.getter(UpdateRevealConfigurationResponse::configuration)).setter(UpdateRevealConfigurationResponse.setter(Builder::configuration)).constructor(RevealConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<RetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrievalConfiguration").getter(UpdateRevealConfigurationResponse.getter(UpdateRevealConfigurationResponse::retrievalConfiguration)).setter(UpdateRevealConfigurationResponse.setter(Builder::retrievalConfiguration)).constructor(RetrievalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, RETRIEVAL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("retrievalConfiguration", RETRIEVAL_CONFIGURATION_FIELD);
        }
    });
    private final RevealConfiguration configuration;
    private final RetrievalConfiguration retrievalConfiguration;

    private UpdateRevealConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.retrievalConfiguration = builder.retrievalConfiguration;
    }

    public final RevealConfiguration configuration() {
        return this.configuration;
    }

    public final RetrievalConfiguration retrievalConfiguration() {
        return this.retrievalConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRevealConfigurationResponse)) {
            return false;
        }
        UpdateRevealConfigurationResponse other = (UpdateRevealConfigurationResponse)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.retrievalConfiguration(), other.retrievalConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRevealConfigurationResponse").add("Configuration", (Object)this.configuration()).add("RetrievalConfiguration", (Object)this.retrievalConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "retrievalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retrievalConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRevealConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateRevealConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private RevealConfiguration configuration;
        private RetrievalConfiguration retrievalConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRevealConfigurationResponse model) {
            super(model);
            this.configuration(model.configuration);
            this.retrievalConfiguration(model.retrievalConfiguration);
        }

        public final RevealConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RevealConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RevealConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final RetrievalConfiguration.Builder getRetrievalConfiguration() {
            return this.retrievalConfiguration != null ? this.retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(RetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(RetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        @Override
        public UpdateRevealConfigurationResponse build() {
            return new UpdateRevealConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRevealConfigurationResponse> {
        public Builder configuration(RevealConfiguration var1);

        default public Builder configuration(Consumer<RevealConfiguration.Builder> configuration) {
            return this.configuration((RevealConfiguration)((RevealConfiguration.Builder)RevealConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder retrievalConfiguration(RetrievalConfiguration var1);

        default public Builder retrievalConfiguration(Consumer<RetrievalConfiguration.Builder> retrievalConfiguration) {
            return this.retrievalConfiguration((RetrievalConfiguration)((RetrievalConfiguration.Builder)RetrievalConfiguration.builder().applyMutation(retrievalConfiguration)).build());
        }
    }
}

