/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.ApiCallDetails;
import software.amazon.awssdk.services.macie2.model.FindingActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingAction> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(FindingAction.getter(FindingAction::actionTypeAsString)).setter(FindingAction.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final SdkField<ApiCallDetails> API_CALL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apiCallDetails").getter(FindingAction.getter(FindingAction::apiCallDetails)).setter(FindingAction.setter(Builder::apiCallDetails)).constructor(ApiCallDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCallDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, API_CALL_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionType", ACTION_TYPE_FIELD);
            this.put("apiCallDetails", API_CALL_DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String actionType;
    private final ApiCallDetails apiCallDetails;

    private FindingAction(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.apiCallDetails = builder.apiCallDetails;
    }

    public final FindingActionType actionType() {
        return FindingActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final ApiCallDetails apiCallDetails() {
        return this.apiCallDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiCallDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingAction)) {
            return false;
        }
        FindingAction other = (FindingAction)obj;
        return Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.apiCallDetails(), other.apiCallDetails());
    }

    public final String toString() {
        return ToString.builder((String)"FindingAction").add("ActionType", (Object)this.actionTypeAsString()).add("ApiCallDetails", (Object)this.apiCallDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "apiCallDetails": {
                return Optional.ofNullable(clazz.cast(this.apiCallDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FindingAction, T> g) {
        return obj -> g.apply((FindingAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionType;
        private ApiCallDetails apiCallDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingAction model) {
            this.actionType(model.actionType);
            this.apiCallDetails(model.apiCallDetails);
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(FindingActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final ApiCallDetails.Builder getApiCallDetails() {
            return this.apiCallDetails != null ? this.apiCallDetails.toBuilder() : null;
        }

        public final void setApiCallDetails(ApiCallDetails.BuilderImpl apiCallDetails) {
            this.apiCallDetails = apiCallDetails != null ? apiCallDetails.build() : null;
        }

        @Override
        public final Builder apiCallDetails(ApiCallDetails apiCallDetails) {
            this.apiCallDetails = apiCallDetails;
            return this;
        }

        public FindingAction build() {
            return new FindingAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingAction> {
        public Builder actionType(String var1);

        public Builder actionType(FindingActionType var1);

        public Builder apiCallDetails(ApiCallDetails var1);

        default public Builder apiCallDetails(Consumer<ApiCallDetails.Builder> apiCallDetails) {
            return this.apiCallDetails((ApiCallDetails)((ApiCallDetails.Builder)ApiCallDetails.builder().applyMutation(apiCallDetails)).build());
        }
    }
}

