/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary;
import software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest;
import software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse;

public class ListClassificationScopesIterable
implements SdkIterable<ListClassificationScopesResponse> {
    private final Macie2Client client;
    private final ListClassificationScopesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClassificationScopesIterable(Macie2Client client, ListClassificationScopesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClassificationScopesResponseFetcher();
    }

    public Iterator<ListClassificationScopesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClassificationScopeSummary> classificationScopes() {
        Function<ListClassificationScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.classificationScopes() != null) {
                return response.classificationScopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClassificationScopesResponseFetcher
    implements SyncPageFetcher<ListClassificationScopesResponse> {
        private ListClassificationScopesResponseFetcher() {
        }

        public boolean hasNextPage(ListClassificationScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClassificationScopesResponse nextPage(ListClassificationScopesResponse previousPage) {
            if (previousPage == null) {
                return ListClassificationScopesIterable.this.client.listClassificationScopes(ListClassificationScopesIterable.this.firstRequest);
            }
            return ListClassificationScopesIterable.this.client.listClassificationScopes((ListClassificationScopesRequest)((Object)ListClassificationScopesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

