/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.AllowListSummary;
import software.amazon.awssdk.services.macie2.model.ListAllowListsRequest;
import software.amazon.awssdk.services.macie2.model.ListAllowListsResponse;

public class ListAllowListsPublisher
implements SdkPublisher<ListAllowListsResponse> {
    private final Macie2AsyncClient client;
    private final ListAllowListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAllowListsPublisher(Macie2AsyncClient client, ListAllowListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAllowListsPublisher(Macie2AsyncClient client, ListAllowListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAllowListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAllowListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AllowListSummary> allowLists() {
        Function<ListAllowListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.allowLists() != null) {
                return response.allowLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAllowListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAllowListsResponseFetcher
    implements AsyncPageFetcher<ListAllowListsResponse> {
        private ListAllowListsResponseFetcher() {
        }

        public boolean hasNextPage(ListAllowListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAllowListsResponse> nextPage(ListAllowListsResponse previousPage) {
            if (previousPage == null) {
                return ListAllowListsPublisher.this.client.listAllowLists(ListAllowListsPublisher.this.firstRequest);
            }
            return ListAllowListsPublisher.this.client.listAllowLists((ListAllowListsRequest)((Object)ListAllowListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

