/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary;

public class ListManagedDataIdentifiersIterable
implements SdkIterable<ListManagedDataIdentifiersResponse> {
    private final Macie2Client client;
    private final ListManagedDataIdentifiersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedDataIdentifiersIterable(Macie2Client client, ListManagedDataIdentifiersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedDataIdentifiersResponseFetcher();
    }

    public Iterator<ListManagedDataIdentifiersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedDataIdentifierSummary> items() {
        Function<ListManagedDataIdentifiersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedDataIdentifiersResponseFetcher
    implements SyncPageFetcher<ListManagedDataIdentifiersResponse> {
        private ListManagedDataIdentifiersResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedDataIdentifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedDataIdentifiersResponse nextPage(ListManagedDataIdentifiersResponse previousPage) {
            if (previousPage == null) {
                return ListManagedDataIdentifiersIterable.this.client.listManagedDataIdentifiers(ListManagedDataIdentifiersIterable.this.firstRequest);
            }
            return ListManagedDataIdentifiersIterable.this.client.listManagedDataIdentifiers((ListManagedDataIdentifiersRequest)((Object)ListManagedDataIdentifiersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

