/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.macie2.Macie2AsyncClient;
import software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesRequest;
import software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesResponse;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.waiters.Macie2AsyncWaiter;
import software.amazon.awssdk.services.macie2.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultMacie2AsyncWaiter
implements Macie2AsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final Macie2AsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetSensitiveDataOccurrencesResponse> findingRevealedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultMacie2AsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (Macie2AsyncClient)Macie2AsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.findingRevealedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetSensitiveDataOccurrencesResponse.class).acceptors(DefaultMacie2AsyncWaiter.findingRevealedWaiterAcceptors())).overrideConfiguration(DefaultMacie2AsyncWaiter.findingRevealedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSensitiveDataOccurrencesResponse>> waitUntilFindingRevealed(GetSensitiveDataOccurrencesRequest getSensitiveDataOccurrencesRequest) {
        return this.findingRevealedWaiter.runAsync(() -> this.client.getSensitiveDataOccurrences(this.applyWaitersUserAgent(getSensitiveDataOccurrencesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSensitiveDataOccurrencesResponse>> waitUntilFindingRevealed(GetSensitiveDataOccurrencesRequest getSensitiveDataOccurrencesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.findingRevealedWaiter.runAsync(() -> this.client.getSensitiveDataOccurrences(this.applyWaitersUserAgent(getSensitiveDataOccurrencesRequest)), DefaultMacie2AsyncWaiter.findingRevealedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetSensitiveDataOccurrencesResponse>> findingRevealedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetSensitiveDataOccurrencesResponse>> result = new ArrayList<WaiterAcceptor<? super GetSensitiveDataOccurrencesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUCCESS");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration findingRevealedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static Macie2AsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends Macie2Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Macie2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements Macie2AsyncWaiter.Builder {
        private Macie2AsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public Macie2AsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public Macie2AsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public Macie2AsyncWaiter.Builder client(Macie2AsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public Macie2AsyncWaiter build() {
            return new DefaultMacie2AsyncWaiter(this);
        }
    }
}

