/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.SearchResourcesComparator;
import software.amazon.awssdk.services.macie2.model.SearchResourcesSimpleCriterionKey;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchResourcesSimpleCriterion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchResourcesSimpleCriterion> {
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comparator").getter(SearchResourcesSimpleCriterion.getter(SearchResourcesSimpleCriterion::comparatorAsString)).setter(SearchResourcesSimpleCriterion.setter(Builder::comparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(SearchResourcesSimpleCriterion.getter(SearchResourcesSimpleCriterion::keyAsString)).setter(SearchResourcesSimpleCriterion.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(SearchResourcesSimpleCriterion.getter(SearchResourcesSimpleCriterion::values)).setter(SearchResourcesSimpleCriterion.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARATOR_FIELD, KEY_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comparator;
    private final String key;
    private final List<String> values;

    private SearchResourcesSimpleCriterion(BuilderImpl builder) {
        this.comparator = builder.comparator;
        this.key = builder.key;
        this.values = builder.values;
    }

    public final SearchResourcesComparator comparator() {
        return SearchResourcesComparator.fromValue(this.comparator);
    }

    public final String comparatorAsString() {
        return this.comparator;
    }

    public final SearchResourcesSimpleCriterionKey key() {
        return SearchResourcesSimpleCriterionKey.fromValue(this.key);
    }

    public final String keyAsString() {
        return this.key;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesSimpleCriterion)) {
            return false;
        }
        SearchResourcesSimpleCriterion other = (SearchResourcesSimpleCriterion)obj;
        return Objects.equals(this.comparatorAsString(), other.comparatorAsString()) && Objects.equals(this.keyAsString(), other.keyAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"SearchResourcesSimpleCriterion").add("Comparator", (Object)this.comparatorAsString()).add("Key", (Object)this.keyAsString()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comparator": {
                return Optional.ofNullable(clazz.cast(this.comparatorAsString()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.keyAsString()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesSimpleCriterion, T> g) {
        return obj -> g.apply((SearchResourcesSimpleCriterion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparator;
        private String key;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesSimpleCriterion model) {
            this.comparator(model.comparator);
            this.key(model.key);
            this.values(model.values);
        }

        public final String getComparator() {
            return this.comparator;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        @Override
        @Transient
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        @Transient
        public final Builder comparator(SearchResourcesComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        @Transient
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        @Transient
        public final Builder key(SearchResourcesSimpleCriterionKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
        }

        @Override
        @Transient
        public final Builder values(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public SearchResourcesSimpleCriterion build() {
            return new SearchResourcesSimpleCriterion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchResourcesSimpleCriterion> {
        public Builder comparator(String var1);

        public Builder comparator(SearchResourcesComparator var1);

        public Builder key(String var1);

        public Builder key(SearchResourcesSimpleCriterionKey var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

