/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.SessionContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FederatedUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FederatedUser> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessKeyId").getter(FederatedUser.getter(FederatedUser::accessKeyId)).setter(FederatedUser.setter(Builder::accessKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(FederatedUser.getter(FederatedUser::accountId)).setter(FederatedUser.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(FederatedUser.getter(FederatedUser::arn)).setter(FederatedUser.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalId").getter(FederatedUser.getter(FederatedUser::principalId)).setter(FederatedUser.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()}).build();
    private static final SdkField<SessionContext> SESSION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionContext").getter(FederatedUser.getter(FederatedUser::sessionContext)).setter(FederatedUser.setter(Builder::sessionContext)).constructor(SessionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD, ACCOUNT_ID_FIELD, ARN_FIELD, PRINCIPAL_ID_FIELD, SESSION_CONTEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessKeyId;
    private final String accountId;
    private final String arn;
    private final String principalId;
    private final SessionContext sessionContext;

    private FederatedUser(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.principalId = builder.principalId;
        this.sessionContext = builder.sessionContext;
    }

    public final String accessKeyId() {
        return this.accessKeyId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final SessionContext sessionContext() {
        return this.sessionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FederatedUser)) {
            return false;
        }
        FederatedUser other = (FederatedUser)obj;
        return Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.sessionContext(), other.sessionContext());
    }

    public final String toString() {
        return ToString.builder((String)"FederatedUser").add("AccessKeyId", (Object)this.accessKeyId()).add("AccountId", (Object)this.accountId()).add("Arn", (Object)this.arn()).add("PrincipalId", (Object)this.principalId()).add("SessionContext", (Object)this.sessionContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "sessionContext": {
                return Optional.ofNullable(clazz.cast(this.sessionContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FederatedUser, T> g) {
        return obj -> g.apply((FederatedUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessKeyId;
        private String accountId;
        private String arn;
        private String principalId;
        private SessionContext sessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(FederatedUser model) {
            this.accessKeyId(model.accessKeyId);
            this.accountId(model.accountId);
            this.arn(model.arn);
            this.principalId(model.principalId);
            this.sessionContext(model.sessionContext);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        @Transient
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        @Transient
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final SessionContext.Builder getSessionContext() {
            return this.sessionContext != null ? this.sessionContext.toBuilder() : null;
        }

        public final void setSessionContext(SessionContext.BuilderImpl sessionContext) {
            this.sessionContext = sessionContext != null ? sessionContext.build() : null;
        }

        @Override
        @Transient
        public final Builder sessionContext(SessionContext sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public FederatedUser build() {
            return new FederatedUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FederatedUser> {
        public Builder accessKeyId(String var1);

        public Builder accountId(String var1);

        public Builder arn(String var1);

        public Builder principalId(String var1);

        public Builder sessionContext(SessionContext var1);

        default public Builder sessionContext(Consumer<SessionContext.Builder> sessionContext) {
            return this.sessionContext((SessionContext)((SessionContext.Builder)SessionContext.builder().applyMutation(sessionContext)).build());
        }
    }
}

