/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UsageType {
    DATA_INVENTORY_EVALUATION("DATA_INVENTORY_EVALUATION"),
    SENSITIVE_DATA_DISCOVERY("SENSITIVE_DATA_DISCOVERY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UsageType> VALUE_MAP;
    private final String value;

    private UsageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UsageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UsageType> knownValues() {
        EnumSet<UsageType> knownValues = EnumSet.allOf(UsageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UsageType.class, UsageType::toString);
    }
}

