/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifierSummary;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.___listOfBatchGetCustomDataIdentifierSummaryCopier;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCustomDataIdentifiersResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, BatchGetCustomDataIdentifiersResponse> {
    private static final SdkField<List<BatchGetCustomDataIdentifierSummary>> CUSTOM_DATA_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customDataIdentifiers").getter(BatchGetCustomDataIdentifiersResponse.getter(BatchGetCustomDataIdentifiersResponse::customDataIdentifiers)).setter(BatchGetCustomDataIdentifiersResponse.setter(Builder::customDataIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetCustomDataIdentifierSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_FOUND_IDENTIFIER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notFoundIdentifierIds").getter(BatchGetCustomDataIdentifiersResponse.getter(BatchGetCustomDataIdentifiersResponse::notFoundIdentifierIds)).setter(BatchGetCustomDataIdentifiersResponse.setter(Builder::notFoundIdentifierIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notFoundIdentifierIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DATA_IDENTIFIERS_FIELD, NOT_FOUND_IDENTIFIER_IDS_FIELD));
    private final List<BatchGetCustomDataIdentifierSummary> customDataIdentifiers;
    private final List<String> notFoundIdentifierIds;

    private BatchGetCustomDataIdentifiersResponse(BuilderImpl builder) {
        super(builder);
        this.customDataIdentifiers = builder.customDataIdentifiers;
        this.notFoundIdentifierIds = builder.notFoundIdentifierIds;
    }

    public final boolean hasCustomDataIdentifiers() {
        return this.customDataIdentifiers != null && !(this.customDataIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<BatchGetCustomDataIdentifierSummary> customDataIdentifiers() {
        return this.customDataIdentifiers;
    }

    public final boolean hasNotFoundIdentifierIds() {
        return this.notFoundIdentifierIds != null && !(this.notFoundIdentifierIds instanceof SdkAutoConstructList);
    }

    public final List<String> notFoundIdentifierIds() {
        return this.notFoundIdentifierIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDataIdentifiers() ? this.customDataIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotFoundIdentifierIds() ? this.notFoundIdentifierIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCustomDataIdentifiersResponse)) {
            return false;
        }
        BatchGetCustomDataIdentifiersResponse other = (BatchGetCustomDataIdentifiersResponse)((Object)obj);
        return this.hasCustomDataIdentifiers() == other.hasCustomDataIdentifiers() && Objects.equals(this.customDataIdentifiers(), other.customDataIdentifiers()) && this.hasNotFoundIdentifierIds() == other.hasNotFoundIdentifierIds() && Objects.equals(this.notFoundIdentifierIds(), other.notFoundIdentifierIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCustomDataIdentifiersResponse").add("CustomDataIdentifiers", this.hasCustomDataIdentifiers() ? this.customDataIdentifiers() : null).add("NotFoundIdentifierIds", this.hasNotFoundIdentifierIds() ? this.notFoundIdentifierIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customDataIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.customDataIdentifiers()));
            }
            case "notFoundIdentifierIds": {
                return Optional.ofNullable(clazz.cast(this.notFoundIdentifierIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCustomDataIdentifiersResponse, T> g) {
        return obj -> g.apply((BatchGetCustomDataIdentifiersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private List<BatchGetCustomDataIdentifierSummary> customDataIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> notFoundIdentifierIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCustomDataIdentifiersResponse model) {
            super(model);
            this.customDataIdentifiers(model.customDataIdentifiers);
            this.notFoundIdentifierIds(model.notFoundIdentifierIds);
        }

        public final List<BatchGetCustomDataIdentifierSummary.Builder> getCustomDataIdentifiers() {
            List<BatchGetCustomDataIdentifierSummary.Builder> result = ___listOfBatchGetCustomDataIdentifierSummaryCopier.copyToBuilder(this.customDataIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomDataIdentifiers(Collection<BatchGetCustomDataIdentifierSummary.BuilderImpl> customDataIdentifiers) {
            this.customDataIdentifiers = ___listOfBatchGetCustomDataIdentifierSummaryCopier.copyFromBuilder(customDataIdentifiers);
        }

        @Override
        @Transient
        public final Builder customDataIdentifiers(Collection<BatchGetCustomDataIdentifierSummary> customDataIdentifiers) {
            this.customDataIdentifiers = ___listOfBatchGetCustomDataIdentifierSummaryCopier.copy(customDataIdentifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customDataIdentifiers(BatchGetCustomDataIdentifierSummary ... customDataIdentifiers) {
            this.customDataIdentifiers(Arrays.asList(customDataIdentifiers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customDataIdentifiers(Consumer<BatchGetCustomDataIdentifierSummary.Builder> ... customDataIdentifiers) {
            this.customDataIdentifiers(Stream.of(customDataIdentifiers).map(c -> (BatchGetCustomDataIdentifierSummary)((BatchGetCustomDataIdentifierSummary.Builder)BatchGetCustomDataIdentifierSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNotFoundIdentifierIds() {
            if (this.notFoundIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notFoundIdentifierIds;
        }

        public final void setNotFoundIdentifierIds(Collection<String> notFoundIdentifierIds) {
            this.notFoundIdentifierIds = ___listOf__stringCopier.copy(notFoundIdentifierIds);
        }

        @Override
        @Transient
        public final Builder notFoundIdentifierIds(Collection<String> notFoundIdentifierIds) {
            this.notFoundIdentifierIds = ___listOf__stringCopier.copy(notFoundIdentifierIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notFoundIdentifierIds(String ... notFoundIdentifierIds) {
            this.notFoundIdentifierIds(Arrays.asList(notFoundIdentifierIds));
            return this;
        }

        @Override
        public BatchGetCustomDataIdentifiersResponse build() {
            return new BatchGetCustomDataIdentifiersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCustomDataIdentifiersResponse> {
        public Builder customDataIdentifiers(Collection<BatchGetCustomDataIdentifierSummary> var1);

        public Builder customDataIdentifiers(BatchGetCustomDataIdentifierSummary ... var1);

        public Builder customDataIdentifiers(Consumer<BatchGetCustomDataIdentifierSummary.Builder> ... var1);

        public Builder notFoundIdentifierIds(Collection<String> var1);

        public Builder notFoundIdentifierIds(String ... var1);
    }
}

