/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.JobDetails;
import software.amazon.awssdk.services.macie2.model.ObjectCountByEncryptionType;
import software.amazon.awssdk.services.macie2.model.ObjectLevelStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchingBucket
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchingBucket> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(MatchingBucket.getter(MatchingBucket::accountId)).setter(MatchingBucket.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(MatchingBucket.getter(MatchingBucket::bucketName)).setter(MatchingBucket.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<Long> CLASSIFIABLE_OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("classifiableObjectCount").getter(MatchingBucket.getter(MatchingBucket::classifiableObjectCount)).setter(MatchingBucket.setter(Builder::classifiableObjectCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableObjectCount").build()}).build();
    private static final SdkField<Long> CLASSIFIABLE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("classifiableSizeInBytes").getter(MatchingBucket.getter(MatchingBucket::classifiableSizeInBytes)).setter(MatchingBucket.setter(Builder::classifiableSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableSizeInBytes").build()}).build();
    private static final SdkField<JobDetails> JOB_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobDetails").getter(MatchingBucket.getter(MatchingBucket::jobDetails)).setter(MatchingBucket.setter(Builder::jobDetails)).constructor(JobDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()}).build();
    private static final SdkField<Long> OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("objectCount").getter(MatchingBucket.getter(MatchingBucket::objectCount)).setter(MatchingBucket.setter(Builder::objectCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectCount").build()}).build();
    private static final SdkField<ObjectCountByEncryptionType> OBJECT_COUNT_BY_ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("objectCountByEncryptionType").getter(MatchingBucket.getter(MatchingBucket::objectCountByEncryptionType)).setter(MatchingBucket.setter(Builder::objectCountByEncryptionType)).constructor(ObjectCountByEncryptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectCountByEncryptionType").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("sizeInBytes").getter(MatchingBucket.getter(MatchingBucket::sizeInBytes)).setter(MatchingBucket.setter(Builder::sizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytes").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_COMPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("sizeInBytesCompressed").getter(MatchingBucket.getter(MatchingBucket::sizeInBytesCompressed)).setter(MatchingBucket.setter(Builder::sizeInBytesCompressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInBytesCompressed").build()}).build();
    private static final SdkField<ObjectLevelStatistics> UNCLASSIFIABLE_OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("unclassifiableObjectCount").getter(MatchingBucket.getter(MatchingBucket::unclassifiableObjectCount)).setter(MatchingBucket.setter(Builder::unclassifiableObjectCount)).constructor(ObjectLevelStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unclassifiableObjectCount").build()}).build();
    private static final SdkField<ObjectLevelStatistics> UNCLASSIFIABLE_OBJECT_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("unclassifiableObjectSizeInBytes").getter(MatchingBucket.getter(MatchingBucket::unclassifiableObjectSizeInBytes)).setter(MatchingBucket.setter(Builder::unclassifiableObjectSizeInBytes)).constructor(ObjectLevelStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unclassifiableObjectSizeInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUCKET_NAME_FIELD, CLASSIFIABLE_OBJECT_COUNT_FIELD, CLASSIFIABLE_SIZE_IN_BYTES_FIELD, JOB_DETAILS_FIELD, OBJECT_COUNT_FIELD, OBJECT_COUNT_BY_ENCRYPTION_TYPE_FIELD, SIZE_IN_BYTES_FIELD, SIZE_IN_BYTES_COMPRESSED_FIELD, UNCLASSIFIABLE_OBJECT_COUNT_FIELD, UNCLASSIFIABLE_OBJECT_SIZE_IN_BYTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String bucketName;
    private final Long classifiableObjectCount;
    private final Long classifiableSizeInBytes;
    private final JobDetails jobDetails;
    private final Long objectCount;
    private final ObjectCountByEncryptionType objectCountByEncryptionType;
    private final Long sizeInBytes;
    private final Long sizeInBytesCompressed;
    private final ObjectLevelStatistics unclassifiableObjectCount;
    private final ObjectLevelStatistics unclassifiableObjectSizeInBytes;

    private MatchingBucket(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.bucketName = builder.bucketName;
        this.classifiableObjectCount = builder.classifiableObjectCount;
        this.classifiableSizeInBytes = builder.classifiableSizeInBytes;
        this.jobDetails = builder.jobDetails;
        this.objectCount = builder.objectCount;
        this.objectCountByEncryptionType = builder.objectCountByEncryptionType;
        this.sizeInBytes = builder.sizeInBytes;
        this.sizeInBytesCompressed = builder.sizeInBytesCompressed;
        this.unclassifiableObjectCount = builder.unclassifiableObjectCount;
        this.unclassifiableObjectSizeInBytes = builder.unclassifiableObjectSizeInBytes;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final Long classifiableObjectCount() {
        return this.classifiableObjectCount;
    }

    public final Long classifiableSizeInBytes() {
        return this.classifiableSizeInBytes;
    }

    public final JobDetails jobDetails() {
        return this.jobDetails;
    }

    public final Long objectCount() {
        return this.objectCount;
    }

    public final ObjectCountByEncryptionType objectCountByEncryptionType() {
        return this.objectCountByEncryptionType;
    }

    public final Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public final Long sizeInBytesCompressed() {
        return this.sizeInBytesCompressed;
    }

    public final ObjectLevelStatistics unclassifiableObjectCount() {
        return this.unclassifiableObjectCount;
    }

    public final ObjectLevelStatistics unclassifiableObjectSizeInBytes() {
        return this.unclassifiableObjectSizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiableObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiableSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectCountByEncryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytesCompressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.unclassifiableObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unclassifiableObjectSizeInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchingBucket)) {
            return false;
        }
        MatchingBucket other = (MatchingBucket)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.classifiableObjectCount(), other.classifiableObjectCount()) && Objects.equals(this.classifiableSizeInBytes(), other.classifiableSizeInBytes()) && Objects.equals(this.jobDetails(), other.jobDetails()) && Objects.equals(this.objectCount(), other.objectCount()) && Objects.equals(this.objectCountByEncryptionType(), other.objectCountByEncryptionType()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes()) && Objects.equals(this.sizeInBytesCompressed(), other.sizeInBytesCompressed()) && Objects.equals(this.unclassifiableObjectCount(), other.unclassifiableObjectCount()) && Objects.equals(this.unclassifiableObjectSizeInBytes(), other.unclassifiableObjectSizeInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"MatchingBucket").add("AccountId", (Object)this.accountId()).add("BucketName", (Object)this.bucketName()).add("ClassifiableObjectCount", (Object)this.classifiableObjectCount()).add("ClassifiableSizeInBytes", (Object)this.classifiableSizeInBytes()).add("JobDetails", (Object)this.jobDetails()).add("ObjectCount", (Object)this.objectCount()).add("ObjectCountByEncryptionType", (Object)this.objectCountByEncryptionType()).add("SizeInBytes", (Object)this.sizeInBytes()).add("SizeInBytesCompressed", (Object)this.sizeInBytesCompressed()).add("UnclassifiableObjectCount", (Object)this.unclassifiableObjectCount()).add("UnclassifiableObjectSizeInBytes", (Object)this.unclassifiableObjectSizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "classifiableObjectCount": {
                return Optional.ofNullable(clazz.cast(this.classifiableObjectCount()));
            }
            case "classifiableSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.classifiableSizeInBytes()));
            }
            case "jobDetails": {
                return Optional.ofNullable(clazz.cast(this.jobDetails()));
            }
            case "objectCount": {
                return Optional.ofNullable(clazz.cast(this.objectCount()));
            }
            case "objectCountByEncryptionType": {
                return Optional.ofNullable(clazz.cast(this.objectCountByEncryptionType()));
            }
            case "sizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
            case "sizeInBytesCompressed": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytesCompressed()));
            }
            case "unclassifiableObjectCount": {
                return Optional.ofNullable(clazz.cast(this.unclassifiableObjectCount()));
            }
            case "unclassifiableObjectSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.unclassifiableObjectSizeInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchingBucket, T> g) {
        return obj -> g.apply((MatchingBucket)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String bucketName;
        private Long classifiableObjectCount;
        private Long classifiableSizeInBytes;
        private JobDetails jobDetails;
        private Long objectCount;
        private ObjectCountByEncryptionType objectCountByEncryptionType;
        private Long sizeInBytes;
        private Long sizeInBytesCompressed;
        private ObjectLevelStatistics unclassifiableObjectCount;
        private ObjectLevelStatistics unclassifiableObjectSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchingBucket model) {
            this.accountId(model.accountId);
            this.bucketName(model.bucketName);
            this.classifiableObjectCount(model.classifiableObjectCount);
            this.classifiableSizeInBytes(model.classifiableSizeInBytes);
            this.jobDetails(model.jobDetails);
            this.objectCount(model.objectCount);
            this.objectCountByEncryptionType(model.objectCountByEncryptionType);
            this.sizeInBytes(model.sizeInBytes);
            this.sizeInBytesCompressed(model.sizeInBytesCompressed);
            this.unclassifiableObjectCount(model.unclassifiableObjectCount);
            this.unclassifiableObjectSizeInBytes(model.unclassifiableObjectSizeInBytes);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final Long getClassifiableObjectCount() {
            return this.classifiableObjectCount;
        }

        @Override
        public final Builder classifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
            return this;
        }

        public final void setClassifiableObjectCount(Long classifiableObjectCount) {
            this.classifiableObjectCount = classifiableObjectCount;
        }

        public final Long getClassifiableSizeInBytes() {
            return this.classifiableSizeInBytes;
        }

        @Override
        public final Builder classifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
            return this;
        }

        public final void setClassifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
        }

        public final JobDetails.Builder getJobDetails() {
            return this.jobDetails != null ? this.jobDetails.toBuilder() : null;
        }

        @Override
        public final Builder jobDetails(JobDetails jobDetails) {
            this.jobDetails = jobDetails;
            return this;
        }

        public final void setJobDetails(JobDetails.BuilderImpl jobDetails) {
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
        }

        public final Long getObjectCount() {
            return this.objectCount;
        }

        @Override
        public final Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public final void setObjectCount(Long objectCount) {
            this.objectCount = objectCount;
        }

        public final ObjectCountByEncryptionType.Builder getObjectCountByEncryptionType() {
            return this.objectCountByEncryptionType != null ? this.objectCountByEncryptionType.toBuilder() : null;
        }

        @Override
        public final Builder objectCountByEncryptionType(ObjectCountByEncryptionType objectCountByEncryptionType) {
            this.objectCountByEncryptionType = objectCountByEncryptionType;
            return this;
        }

        public final void setObjectCountByEncryptionType(ObjectCountByEncryptionType.BuilderImpl objectCountByEncryptionType) {
            this.objectCountByEncryptionType = objectCountByEncryptionType != null ? objectCountByEncryptionType.build() : null;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public final Long getSizeInBytesCompressed() {
            return this.sizeInBytesCompressed;
        }

        @Override
        public final Builder sizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
            return this;
        }

        public final void setSizeInBytesCompressed(Long sizeInBytesCompressed) {
            this.sizeInBytesCompressed = sizeInBytesCompressed;
        }

        public final ObjectLevelStatistics.Builder getUnclassifiableObjectCount() {
            return this.unclassifiableObjectCount != null ? this.unclassifiableObjectCount.toBuilder() : null;
        }

        @Override
        public final Builder unclassifiableObjectCount(ObjectLevelStatistics unclassifiableObjectCount) {
            this.unclassifiableObjectCount = unclassifiableObjectCount;
            return this;
        }

        public final void setUnclassifiableObjectCount(ObjectLevelStatistics.BuilderImpl unclassifiableObjectCount) {
            this.unclassifiableObjectCount = unclassifiableObjectCount != null ? unclassifiableObjectCount.build() : null;
        }

        public final ObjectLevelStatistics.Builder getUnclassifiableObjectSizeInBytes() {
            return this.unclassifiableObjectSizeInBytes != null ? this.unclassifiableObjectSizeInBytes.toBuilder() : null;
        }

        @Override
        public final Builder unclassifiableObjectSizeInBytes(ObjectLevelStatistics unclassifiableObjectSizeInBytes) {
            this.unclassifiableObjectSizeInBytes = unclassifiableObjectSizeInBytes;
            return this;
        }

        public final void setUnclassifiableObjectSizeInBytes(ObjectLevelStatistics.BuilderImpl unclassifiableObjectSizeInBytes) {
            this.unclassifiableObjectSizeInBytes = unclassifiableObjectSizeInBytes != null ? unclassifiableObjectSizeInBytes.build() : null;
        }

        public MatchingBucket build() {
            return new MatchingBucket(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchingBucket> {
        public Builder accountId(String var1);

        public Builder bucketName(String var1);

        public Builder classifiableObjectCount(Long var1);

        public Builder classifiableSizeInBytes(Long var1);

        public Builder jobDetails(JobDetails var1);

        default public Builder jobDetails(Consumer<JobDetails.Builder> jobDetails) {
            return this.jobDetails((JobDetails)((JobDetails.Builder)JobDetails.builder().applyMutation(jobDetails)).build());
        }

        public Builder objectCount(Long var1);

        public Builder objectCountByEncryptionType(ObjectCountByEncryptionType var1);

        default public Builder objectCountByEncryptionType(Consumer<ObjectCountByEncryptionType.Builder> objectCountByEncryptionType) {
            return this.objectCountByEncryptionType((ObjectCountByEncryptionType)((ObjectCountByEncryptionType.Builder)ObjectCountByEncryptionType.builder().applyMutation(objectCountByEncryptionType)).build());
        }

        public Builder sizeInBytes(Long var1);

        public Builder sizeInBytesCompressed(Long var1);

        public Builder unclassifiableObjectCount(ObjectLevelStatistics var1);

        default public Builder unclassifiableObjectCount(Consumer<ObjectLevelStatistics.Builder> unclassifiableObjectCount) {
            return this.unclassifiableObjectCount((ObjectLevelStatistics)((ObjectLevelStatistics.Builder)ObjectLevelStatistics.builder().applyMutation(unclassifiableObjectCount)).build());
        }

        public Builder unclassifiableObjectSizeInBytes(ObjectLevelStatistics var1);

        default public Builder unclassifiableObjectSizeInBytes(Consumer<ObjectLevelStatistics.Builder> unclassifiableObjectSizeInBytes) {
            return this.unclassifiableObjectSizeInBytes((ObjectLevelStatistics)((ObjectLevelStatistics.Builder)ObjectLevelStatistics.builder().applyMutation(unclassifiableObjectSizeInBytes)).build());
        }
    }
}

