/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketDefinitionForJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketDefinitionForJob> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(S3BucketDefinitionForJob.getter(S3BucketDefinitionForJob::accountId)).setter(S3BucketDefinitionForJob.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<List<String>> BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buckets").getter(S3BucketDefinitionForJob.getter(S3BucketDefinitionForJob::buckets)).setter(S3BucketDefinitionForJob.setter(Builder::buckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buckets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BUCKETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final List<String> buckets;

    private S3BucketDefinitionForJob(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.buckets = builder.buckets;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasBuckets() {
        return this.buckets != null && !(this.buckets instanceof SdkAutoConstructList);
    }

    public final List<String> buckets() {
        return this.buckets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuckets() ? this.buckets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketDefinitionForJob)) {
            return false;
        }
        S3BucketDefinitionForJob other = (S3BucketDefinitionForJob)obj;
        return Objects.equals(this.accountId(), other.accountId()) && this.hasBuckets() == other.hasBuckets() && Objects.equals(this.buckets(), other.buckets());
    }

    public final String toString() {
        return ToString.builder((String)"S3BucketDefinitionForJob").add("AccountId", (Object)this.accountId()).add("Buckets", this.hasBuckets() ? this.buckets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "buckets": {
                return Optional.ofNullable(clazz.cast(this.buckets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketDefinitionForJob, T> g) {
        return obj -> g.apply((S3BucketDefinitionForJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private List<String> buckets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketDefinitionForJob model) {
            this.accountId(model.accountId);
            this.buckets(model.buckets);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Collection<String> getBuckets() {
            if (this.buckets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.buckets;
        }

        public final void setBuckets(Collection<String> buckets) {
            this.buckets = ___listOf__stringCopier.copy(buckets);
        }

        @Override
        @Transient
        public final Builder buckets(Collection<String> buckets) {
            this.buckets = ___listOf__stringCopier.copy(buckets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder buckets(String ... buckets) {
            this.buckets(Arrays.asList(buckets));
            return this;
        }

        public S3BucketDefinitionForJob build() {
            return new S3BucketDefinitionForJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketDefinitionForJob> {
        public Builder accountId(String var1);

        public Builder buckets(Collection<String> var1);

        public Builder buckets(String ... var1);
    }
}

