/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Range;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Page
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Page> {
    private static final SdkField<Range> LINE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lineRange").getter(Page.getter(Page::lineRange)).setter(Page.setter(Builder::lineRange)).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineRange").build()}).build();
    private static final SdkField<Range> OFFSET_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("offsetRange").getter(Page.getter(Page::offsetRange)).setter(Page.setter(Builder::offsetRange)).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offsetRange").build()}).build();
    private static final SdkField<Long> PAGE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("pageNumber").getter(Page.getter(Page::pageNumber)).setter(Page.setter(Builder::pageNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_RANGE_FIELD, OFFSET_RANGE_FIELD, PAGE_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Range lineRange;
    private final Range offsetRange;
    private final Long pageNumber;

    private Page(BuilderImpl builder) {
        this.lineRange = builder.lineRange;
        this.offsetRange = builder.offsetRange;
        this.pageNumber = builder.pageNumber;
    }

    public final Range lineRange() {
        return this.lineRange;
    }

    public final Range offsetRange() {
        return this.offsetRange;
    }

    public final Long pageNumber() {
        return this.pageNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lineRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.offsetRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page)obj;
        return Objects.equals(this.lineRange(), other.lineRange()) && Objects.equals(this.offsetRange(), other.offsetRange()) && Objects.equals(this.pageNumber(), other.pageNumber());
    }

    public final String toString() {
        return ToString.builder((String)"Page").add("LineRange", (Object)this.lineRange()).add("OffsetRange", (Object)this.offsetRange()).add("PageNumber", (Object)this.pageNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lineRange": {
                return Optional.ofNullable(clazz.cast(this.lineRange()));
            }
            case "offsetRange": {
                return Optional.ofNullable(clazz.cast(this.offsetRange()));
            }
            case "pageNumber": {
                return Optional.ofNullable(clazz.cast(this.pageNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Page, T> g) {
        return obj -> g.apply((Page)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Range lineRange;
        private Range offsetRange;
        private Long pageNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Page model) {
            this.lineRange(model.lineRange);
            this.offsetRange(model.offsetRange);
            this.pageNumber(model.pageNumber);
        }

        public final Range.Builder getLineRange() {
            return this.lineRange != null ? this.lineRange.toBuilder() : null;
        }

        public final void setLineRange(Range.BuilderImpl lineRange) {
            this.lineRange = lineRange != null ? lineRange.build() : null;
        }

        @Override
        @Transient
        public final Builder lineRange(Range lineRange) {
            this.lineRange = lineRange;
            return this;
        }

        public final Range.Builder getOffsetRange() {
            return this.offsetRange != null ? this.offsetRange.toBuilder() : null;
        }

        public final void setOffsetRange(Range.BuilderImpl offsetRange) {
            this.offsetRange = offsetRange != null ? offsetRange.build() : null;
        }

        @Override
        @Transient
        public final Builder offsetRange(Range offsetRange) {
            this.offsetRange = offsetRange;
            return this;
        }

        public final Long getPageNumber() {
            return this.pageNumber;
        }

        public final void setPageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        @Transient
        public final Builder pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public Page build() {
            return new Page(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Page> {
        public Builder lineRange(Range var1);

        default public Builder lineRange(Consumer<Range.Builder> lineRange) {
            return this.lineRange((Range)((Range.Builder)Range.builder().applyMutation(lineRange)).build());
        }

        public Builder offsetRange(Range var1);

        default public Builder offsetRange(Consumer<Range.Builder> offsetRange) {
            return this.offsetRange((Range)((Range.Builder)Range.builder().applyMutation(offsetRange)).build());
        }

        public Builder pageNumber(Long var1);
    }
}

