/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a weekly recurrence pattern for running a classification job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeeklySchedule implements SdkPojo, Serializable, ToCopyableBuilder<WeeklySchedule.Builder, WeeklySchedule> {
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dayOfWeek").getter(getter(WeeklySchedule::dayOfWeekAsString)).setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfWeek").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_WEEK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dayOfWeek;

    private WeeklySchedule(BuilderImpl builder) {
        this.dayOfWeek = builder.dayOfWeek;
    }

    /**
     * <p>
     * The day of the week when Amazon Macie runs the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week when Amazon Macie runs the job.
     * @see DayOfWeek
     */
    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(dayOfWeek);
    }

    /**
     * <p>
     * The day of the week when Amazon Macie runs the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return The day of the week when Amazon Macie runs the job.
     * @see DayOfWeek
     */
    public final String dayOfWeekAsString() {
        return dayOfWeek;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeekAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklySchedule)) {
            return false;
        }
        WeeklySchedule other = (WeeklySchedule) obj;
        return Objects.equals(dayOfWeekAsString(), other.dayOfWeekAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WeeklySchedule").add("DayOfWeek", dayOfWeekAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeekAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeeklySchedule, T> g) {
        return obj -> g.apply((WeeklySchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeeklySchedule> {
        /**
         * <p>
         * The day of the week when Amazon Macie runs the job.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week when Amazon Macie runs the job.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(String dayOfWeek);

        /**
         * <p>
         * The day of the week when Amazon Macie runs the job.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week when Amazon Macie runs the job.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(DayOfWeek dayOfWeek);
    }

    static final class BuilderImpl implements Builder {
        private String dayOfWeek;

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklySchedule model) {
            dayOfWeek(model.dayOfWeek);
        }

        public final String getDayOfWeek() {
            return dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public WeeklySchedule build() {
            return new WeeklySchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
