/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingStatisticsResponse extends Macie2Response implements
        ToCopyableBuilder<GetFindingStatisticsResponse.Builder, GetFindingStatisticsResponse> {
    private static final SdkField<List<GroupCount>> COUNTS_BY_GROUP_FIELD = SdkField
            .<List<GroupCount>> builder(MarshallingType.LIST)
            .memberName("countsByGroup")
            .getter(getter(GetFindingStatisticsResponse::countsByGroup))
            .setter(setter(Builder::countsByGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countsByGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupCount> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupCount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTS_BY_GROUP_FIELD));

    private final List<GroupCount> countsByGroup;

    private GetFindingStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.countsByGroup = builder.countsByGroup;
    }

    /**
     * Returns true if the CountsByGroup property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCountsByGroup() {
        return countsByGroup != null && !(countsByGroup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each group of findings that meet the filter criteria specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCountsByGroup()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each group of findings that meet the filter criteria specified in the
     *         request.
     */
    public final List<GroupCount> countsByGroup() {
        return countsByGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCountsByGroup() ? countsByGroup() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingStatisticsResponse)) {
            return false;
        }
        GetFindingStatisticsResponse other = (GetFindingStatisticsResponse) obj;
        return hasCountsByGroup() == other.hasCountsByGroup() && Objects.equals(countsByGroup(), other.countsByGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingStatisticsResponse").add("CountsByGroup", hasCountsByGroup() ? countsByGroup() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "countsByGroup":
            return Optional.ofNullable(clazz.cast(countsByGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingStatisticsResponse, T> g) {
        return obj -> g.apply((GetFindingStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingStatisticsResponse> {
        /**
         * <p>
         * An array of objects, one for each group of findings that meet the filter criteria specified in the request.
         * </p>
         * 
         * @param countsByGroup
         *        An array of objects, one for each group of findings that meet the filter criteria specified in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countsByGroup(Collection<GroupCount> countsByGroup);

        /**
         * <p>
         * An array of objects, one for each group of findings that meet the filter criteria specified in the request.
         * </p>
         * 
         * @param countsByGroup
         *        An array of objects, one for each group of findings that meet the filter criteria specified in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countsByGroup(GroupCount... countsByGroup);

        /**
         * <p>
         * An array of objects, one for each group of findings that meet the filter criteria specified in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupCount>.Builder} avoiding the need to
         * create one manually via {@link List<GroupCount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupCount>.Builder#build()} is called immediately and its
         * result is passed to {@link #countsByGroup(List<GroupCount>)}.
         * 
         * @param countsByGroup
         *        a consumer that will call methods on {@link List<GroupCount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #countsByGroup(List<GroupCount>)
         */
        Builder countsByGroup(Consumer<GroupCount.Builder>... countsByGroup);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<GroupCount> countsByGroup = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingStatisticsResponse model) {
            super(model);
            countsByGroup(model.countsByGroup);
        }

        public final Collection<GroupCount.Builder> getCountsByGroup() {
            if (countsByGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return countsByGroup != null ? countsByGroup.stream().map(GroupCount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder countsByGroup(Collection<GroupCount> countsByGroup) {
            this.countsByGroup = ___listOfGroupCountCopier.copy(countsByGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countsByGroup(GroupCount... countsByGroup) {
            countsByGroup(Arrays.asList(countsByGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countsByGroup(Consumer<GroupCount.Builder>... countsByGroup) {
            countsByGroup(Stream.of(countsByGroup).map(c -> GroupCount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCountsByGroup(Collection<GroupCount.BuilderImpl> countsByGroup) {
            this.countsByGroup = ___listOfGroupCountCopier.copyFromBuilder(countsByGroup);
        }

        @Override
        public GetFindingStatisticsResponse build() {
            return new GetFindingStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
