/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSampleFindingsRequest extends Macie2Request implements
        ToCopyableBuilder<CreateSampleFindingsRequest.Builder, CreateSampleFindingsRequest> {
    private static final SdkField<List<String>> FINDING_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("findingTypes")
            .getter(getter(CreateSampleFindingsRequest::findingTypesAsStrings))
            .setter(setter(Builder::findingTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_TYPES_FIELD));

    private final List<String> findingTypes;

    private CreateSampleFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingTypes = builder.findingTypes;
    }

    /**
     * <p>
     * An array that lists one or more types of findings to include in the set of sample findings. Currently, the only
     * supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that lists one or more types of findings to include in the set of sample findings. Currently,
     *         the only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
     */
    public final List<FindingType> findingTypes() {
        return ___listOfFindingTypeCopier.copyStringToEnum(findingTypes);
    }

    /**
     * Returns true if the FindingTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFindingTypes() {
        return findingTypes != null && !(findingTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists one or more types of findings to include in the set of sample findings. Currently, the only
     * supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that lists one or more types of findings to include in the set of sample findings. Currently,
     *         the only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
     */
    public final List<String> findingTypesAsStrings() {
        return findingTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingTypes() ? findingTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSampleFindingsRequest)) {
            return false;
        }
        CreateSampleFindingsRequest other = (CreateSampleFindingsRequest) obj;
        return hasFindingTypes() == other.hasFindingTypes()
                && Objects.equals(findingTypesAsStrings(), other.findingTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSampleFindingsRequest")
                .add("FindingTypes", hasFindingTypes() ? findingTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingTypes":
            return Optional.ofNullable(clazz.cast(findingTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSampleFindingsRequest, T> g) {
        return obj -> g.apply((CreateSampleFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateSampleFindingsRequest> {
        /**
         * <p>
         * An array that lists one or more types of findings to include in the set of sample findings. Currently, the
         * only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
         * </p>
         * 
         * @param findingTypes
         *        An array that lists one or more types of findings to include in the set of sample findings. Currently,
         *        the only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingTypesWithStrings(Collection<String> findingTypes);

        /**
         * <p>
         * An array that lists one or more types of findings to include in the set of sample findings. Currently, the
         * only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
         * </p>
         * 
         * @param findingTypes
         *        An array that lists one or more types of findings to include in the set of sample findings. Currently,
         *        the only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingTypesWithStrings(String... findingTypes);

        /**
         * <p>
         * An array that lists one or more types of findings to include in the set of sample findings. Currently, the
         * only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
         * </p>
         * 
         * @param findingTypes
         *        An array that lists one or more types of findings to include in the set of sample findings. Currently,
         *        the only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingTypes(Collection<FindingType> findingTypes);

        /**
         * <p>
         * An array that lists one or more types of findings to include in the set of sample findings. Currently, the
         * only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
         * </p>
         * 
         * @param findingTypes
         *        An array that lists one or more types of findings to include in the set of sample findings. Currently,
         *        the only supported value is Policy:IAMUser/S3BucketEncryptionDisabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingTypes(FindingType... findingTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private List<String> findingTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSampleFindingsRequest model) {
            super(model);
            findingTypesWithStrings(model.findingTypes);
        }

        public final Collection<String> getFindingTypes() {
            if (findingTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return findingTypes;
        }

        @Override
        public final Builder findingTypesWithStrings(Collection<String> findingTypes) {
            this.findingTypes = ___listOfFindingTypeCopier.copy(findingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingTypesWithStrings(String... findingTypes) {
            findingTypesWithStrings(Arrays.asList(findingTypes));
            return this;
        }

        @Override
        public final Builder findingTypes(Collection<FindingType> findingTypes) {
            this.findingTypes = ___listOfFindingTypeCopier.copyEnumToString(findingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingTypes(FindingType... findingTypes) {
            findingTypes(Arrays.asList(findingTypes));
            return this;
        }

        public final void setFindingTypes(Collection<String> findingTypes) {
            this.findingTypes = ___listOfFindingTypeCopier.copy(findingTypes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSampleFindingsRequest build() {
            return new CreateSampleFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
