/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvitationsResponse extends Macie2Response implements
        ToCopyableBuilder<CreateInvitationsResponse.Builder, CreateInvitationsResponse> {
    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<UnprocessedAccount>> builder(MarshallingType.LIST)
            .memberName("unprocessedAccounts")
            .getter(getter(CreateInvitationsResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNPROCESSED_ACCOUNTS_FIELD));

    private final List<UnprocessedAccount> unprocessedAccounts;

    private CreateInvitationsResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * Returns true if the UnprocessedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each account whose invitation hasn't been processed. Each object identifies the
     * account and explains why the invitation hasn't been processed for the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each account whose invitation hasn't been processed. Each object identifies
     *         the account and explains why the invitation hasn't been processed for the account.
     */
    public final List<UnprocessedAccount> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAccounts() ? unprocessedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvitationsResponse)) {
            return false;
        }
        CreateInvitationsResponse other = (CreateInvitationsResponse) obj;
        return hasUnprocessedAccounts() == other.hasUnprocessedAccounts()
                && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInvitationsResponse")
                .add("UnprocessedAccounts", hasUnprocessedAccounts() ? unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInvitationsResponse, T> g) {
        return obj -> g.apply((CreateInvitationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateInvitationsResponse> {
        /**
         * <p>
         * An array of objects, one for each account whose invitation hasn't been processed. Each object identifies the
         * account and explains why the invitation hasn't been processed for the account.
         * </p>
         * 
         * @param unprocessedAccounts
         *        An array of objects, one for each account whose invitation hasn't been processed. Each object
         *        identifies the account and explains why the invitation hasn't been processed for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts);

        /**
         * <p>
         * An array of objects, one for each account whose invitation hasn't been processed. Each object identifies the
         * account and explains why the invitation hasn't been processed for the account.
         * </p>
         * 
         * @param unprocessedAccounts
         *        An array of objects, one for each account whose invitation hasn't been processed. Each object
         *        identifies the account and explains why the invitation hasn't been processed for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts);

        /**
         * <p>
         * An array of objects, one for each account whose invitation hasn't been processed. Each object identifies the
         * account and explains why the invitation hasn't been processed for the account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedAccount>.Builder} avoiding the
         * need to create one manually via {@link List<UnprocessedAccount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedAccount>.Builder#build()} is called immediately
         * and its result is passed to {@link #unprocessedAccounts(List<UnprocessedAccount>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on {@link List<UnprocessedAccount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(List<UnprocessedAccount>)
         */
        Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvitationsResponse model) {
            super(model);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final Collection<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            if (unprocessedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return unprocessedAccounts != null ? unprocessedAccounts.stream().map(UnprocessedAccount::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = ___listOfUnprocessedAccountCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> UnprocessedAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = ___listOfUnprocessedAccountCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public CreateInvitationsResponse build() {
            return new CreateInvitationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
