/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the default server-side encryption settings for an S3 bucket. For detailed information
 * about these settings, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html">Setting default server-side
 * encryption behavior for Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketServerSideEncryption implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketServerSideEncryption.Builder, BucketServerSideEncryption> {
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsMasterKeyId").getter(getter(BucketServerSideEncryption::kmsMasterKeyId))
            .setter(setter(Builder::kmsMasterKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsMasterKeyId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(BucketServerSideEncryption::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_MASTER_KEY_ID_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsMasterKeyId;

    private final String type;

    private BucketServerSideEncryption(BuilderImpl builder) {
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or unique identifier (key ID) for the AWS Key Management Service (AWS KMS)
     * customer master key (CMK) that's used by default to encrypt objects that are added to the bucket. This value is
     * null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects
     * by default.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or unique identifier (key ID) for the AWS Key Management Service (AWS KMS)
     *         customer master key (CMK) that's used by default to encrypt objects that are added to the bucket. This
     *         value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't
     *         encrypt new objects by default.
     */
    public final String kmsMasterKeyId() {
        return kmsMasterKeyId;
    }

    /**
     * <p>
     * The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption (SSE-S3).
     * </p>
     * </li>
     * <li>
     * <p>
     * aws:kms - New objects are encrypted with an AWS KMS CMK, specified by the kmsMasterKeyId property, and use AWS
     * managed AWS KMS encryption (AWS-KMS) or customer managed AWS KMS encryption (SSE-KMS).
     * </p>
     * </li>
     * <li>
     * <p>
     * NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that's used by default when storing new objects in the bucket.
     *         Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption
     *         (SSE-S3).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         aws:kms - New objects are encrypted with an AWS KMS CMK, specified by the kmsMasterKeyId property, and
     *         use AWS managed AWS KMS encryption (AWS-KMS) or customer managed AWS KMS encryption (SSE-KMS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
     *         </p>
     *         </li>
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption (SSE-S3).
     * </p>
     * </li>
     * <li>
     * <p>
     * aws:kms - New objects are encrypted with an AWS KMS CMK, specified by the kmsMasterKeyId property, and use AWS
     * managed AWS KMS encryption (AWS-KMS) or customer managed AWS KMS encryption (SSE-KMS).
     * </p>
     * </li>
     * <li>
     * <p>
     * NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that's used by default when storing new objects in the bucket.
     *         Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption
     *         (SSE-S3).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         aws:kms - New objects are encrypted with an AWS KMS CMK, specified by the kmsMasterKeyId property, and
     *         use AWS managed AWS KMS encryption (AWS-KMS) or customer managed AWS KMS encryption (SSE-KMS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
     *         </p>
     *         </li>
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketServerSideEncryption)) {
            return false;
        }
        BucketServerSideEncryption other = (BucketServerSideEncryption) obj;
        return Objects.equals(kmsMasterKeyId(), other.kmsMasterKeyId()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketServerSideEncryption").add("KmsMasterKeyId", kmsMasterKeyId()).add("Type", typeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsMasterKeyId":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketServerSideEncryption, T> g) {
        return obj -> g.apply((BucketServerSideEncryption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketServerSideEncryption> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or unique identifier (key ID) for the AWS Key Management Service (AWS KMS)
         * customer master key (CMK) that's used by default to encrypt objects that are added to the bucket. This value
         * is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new
         * objects by default.
         * </p>
         * 
         * @param kmsMasterKeyId
         *        The Amazon Resource Name (ARN) or unique identifier (key ID) for the AWS Key Management Service (AWS
         *        KMS) customer master key (CMK) that's used by default to encrypt objects that are added to the bucket.
         *        This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket
         *        doesn't encrypt new objects by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyId(String kmsMasterKeyId);

        /**
         * <p>
         * The type of server-side encryption that's used by default when storing new objects in the bucket. Possible
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption
         * (SSE-S3).
         * </p>
         * </li>
         * <li>
         * <p>
         * aws:kms - New objects are encrypted with an AWS KMS CMK, specified by the kmsMasterKeyId property, and use
         * AWS managed AWS KMS encryption (AWS-KMS) or customer managed AWS KMS encryption (SSE-KMS).
         * </p>
         * </li>
         * <li>
         * <p>
         * NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of server-side encryption that's used by default when storing new objects in the bucket.
         *        Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption
         *        (SSE-S3).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        aws:kms - New objects are encrypted with an AWS KMS CMK, specified by the kmsMasterKeyId property, and
         *        use AWS managed AWS KMS encryption (AWS-KMS) or customer managed AWS KMS encryption (SSE-KMS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
         *        </p>
         *        </li>
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of server-side encryption that's used by default when storing new objects in the bucket. Possible
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption
         * (SSE-S3).
         * </p>
         * </li>
         * <li>
         * <p>
         * aws:kms - New objects are encrypted with an AWS KMS CMK, specified by the kmsMasterKeyId property, and use
         * AWS managed AWS KMS encryption (AWS-KMS) or customer managed AWS KMS encryption (SSE-KMS).
         * </p>
         * </li>
         * <li>
         * <p>
         * NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of server-side encryption that's used by default when storing new objects in the bucket.
         *        Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AES256 - New objects are encrypted with an Amazon S3 managed key and use Amazon S3 managed encryption
         *        (SSE-S3).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        aws:kms - New objects are encrypted with an AWS KMS CMK, specified by the kmsMasterKeyId property, and
         *        use AWS managed AWS KMS encryption (AWS-KMS) or customer managed AWS KMS encryption (SSE-KMS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
         *        </p>
         *        </li>
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);
    }

    static final class BuilderImpl implements Builder {
        private String kmsMasterKeyId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketServerSideEncryption model) {
            kmsMasterKeyId(model.kmsMasterKeyId);
            type(model.type);
        }

        public final String getKmsMasterKeyId() {
            return kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public BucketServerSideEncryption build() {
            return new BucketServerSideEncryption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
