/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.FindingsFilterListItem;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.___listOfFindingsFilterListItemCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFindingsFiltersResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, ListFindingsFiltersResponse> {
    private static final SdkField<List<FindingsFilterListItem>> FINDINGS_FILTER_LIST_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingsFilterListItems").getter(ListFindingsFiltersResponse.getter(ListFindingsFiltersResponse::findingsFilterListItems)).setter(ListFindingsFiltersResponse.setter(Builder::findingsFilterListItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingsFilterListItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingsFilterListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFindingsFiltersResponse.getter(ListFindingsFiltersResponse::nextToken)).setter(ListFindingsFiltersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FILTER_LIST_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<FindingsFilterListItem> findingsFilterListItems;
    private final String nextToken;

    private ListFindingsFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.findingsFilterListItems = builder.findingsFilterListItems;
        this.nextToken = builder.nextToken;
    }

    public boolean hasFindingsFilterListItems() {
        return this.findingsFilterListItems != null && !(this.findingsFilterListItems instanceof SdkAutoConstructList);
    }

    public List<FindingsFilterListItem> findingsFilterListItems() {
        return this.findingsFilterListItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingsFilterListItems() ? this.findingsFilterListItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsFiltersResponse)) {
            return false;
        }
        ListFindingsFiltersResponse other = (ListFindingsFiltersResponse)((Object)obj);
        return this.hasFindingsFilterListItems() == other.hasFindingsFilterListItems() && Objects.equals(this.findingsFilterListItems(), other.findingsFilterListItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFindingsFiltersResponse").add("FindingsFilterListItems", this.hasFindingsFilterListItems() ? this.findingsFilterListItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingsFilterListItems": {
                return Optional.ofNullable(clazz.cast(this.findingsFilterListItems()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsFiltersResponse, T> g) {
        return obj -> g.apply((ListFindingsFiltersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private List<FindingsFilterListItem> findingsFilterListItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsFiltersResponse model) {
            super(model);
            this.findingsFilterListItems(model.findingsFilterListItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<FindingsFilterListItem.Builder> getFindingsFilterListItems() {
            if (this.findingsFilterListItems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingsFilterListItems != null ? (Collection)this.findingsFilterListItems.stream().map(FindingsFilterListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findingsFilterListItems(Collection<FindingsFilterListItem> findingsFilterListItems) {
            this.findingsFilterListItems = ___listOfFindingsFilterListItemCopier.copy(findingsFilterListItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsFilterListItems(FindingsFilterListItem ... findingsFilterListItems) {
            this.findingsFilterListItems(Arrays.asList(findingsFilterListItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsFilterListItems(Consumer<FindingsFilterListItem.Builder> ... findingsFilterListItems) {
            this.findingsFilterListItems(Stream.of(findingsFilterListItems).map(c -> (FindingsFilterListItem)((FindingsFilterListItem.Builder)FindingsFilterListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindingsFilterListItems(Collection<FindingsFilterListItem.BuilderImpl> findingsFilterListItems) {
            this.findingsFilterListItems = ___listOfFindingsFilterListItemCopier.copyFromBuilder(findingsFilterListItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFindingsFiltersResponse build() {
            return new ListFindingsFiltersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFindingsFiltersResponse> {
        public Builder findingsFilterListItems(Collection<FindingsFilterListItem> var1);

        public Builder findingsFilterListItems(FindingsFilterListItem ... var1);

        public Builder findingsFilterListItems(Consumer<FindingsFilterListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

