/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration;
import software.amazon.awssdk.services.macie2.model.EffectivePermission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketPublicAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketPublicAccess> {
    private static final SdkField<String> EFFECTIVE_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("effectivePermission").getter(BucketPublicAccess.getter(BucketPublicAccess::effectivePermissionAsString)).setter(BucketPublicAccess.setter(Builder::effectivePermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectivePermission").build()}).build();
    private static final SdkField<BucketPermissionConfiguration> PERMISSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("permissionConfiguration").getter(BucketPublicAccess.getter(BucketPublicAccess::permissionConfiguration)).setter(BucketPublicAccess.setter(Builder::permissionConfiguration)).constructor(BucketPermissionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_PERMISSION_FIELD, PERMISSION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String effectivePermission;
    private final BucketPermissionConfiguration permissionConfiguration;

    private BucketPublicAccess(BuilderImpl builder) {
        this.effectivePermission = builder.effectivePermission;
        this.permissionConfiguration = builder.permissionConfiguration;
    }

    public EffectivePermission effectivePermission() {
        return EffectivePermission.fromValue(this.effectivePermission);
    }

    public String effectivePermissionAsString() {
        return this.effectivePermission;
    }

    public BucketPermissionConfiguration permissionConfiguration() {
        return this.permissionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.effectivePermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketPublicAccess)) {
            return false;
        }
        BucketPublicAccess other = (BucketPublicAccess)obj;
        return Objects.equals(this.effectivePermissionAsString(), other.effectivePermissionAsString()) && Objects.equals(this.permissionConfiguration(), other.permissionConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"BucketPublicAccess").add("EffectivePermission", (Object)this.effectivePermissionAsString()).add("PermissionConfiguration", (Object)this.permissionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "effectivePermission": {
                return Optional.ofNullable(clazz.cast(this.effectivePermissionAsString()));
            }
            case "permissionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.permissionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketPublicAccess, T> g) {
        return obj -> g.apply((BucketPublicAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String effectivePermission;
        private BucketPermissionConfiguration permissionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketPublicAccess model) {
            this.effectivePermission(model.effectivePermission);
            this.permissionConfiguration(model.permissionConfiguration);
        }

        public final String getEffectivePermission() {
            return this.effectivePermission;
        }

        @Override
        public final Builder effectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
            return this;
        }

        @Override
        public final Builder effectivePermission(EffectivePermission effectivePermission) {
            this.effectivePermission(effectivePermission == null ? null : effectivePermission.toString());
            return this;
        }

        public final void setEffectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
        }

        public final BucketPermissionConfiguration.Builder getPermissionConfiguration() {
            return this.permissionConfiguration != null ? this.permissionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder permissionConfiguration(BucketPermissionConfiguration permissionConfiguration) {
            this.permissionConfiguration = permissionConfiguration;
            return this;
        }

        public final void setPermissionConfiguration(BucketPermissionConfiguration.BuilderImpl permissionConfiguration) {
            this.permissionConfiguration = permissionConfiguration != null ? permissionConfiguration.build() : null;
        }

        public BucketPublicAccess build() {
            return new BucketPublicAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketPublicAccess> {
        public Builder effectivePermission(String var1);

        public Builder effectivePermission(EffectivePermission var1);

        public Builder permissionConfiguration(BucketPermissionConfiguration var1);

        default public Builder permissionConfiguration(Consumer<BucketPermissionConfiguration.Builder> permissionConfiguration) {
            return this.permissionConfiguration((BucketPermissionConfiguration)((BucketPermissionConfiguration.Builder)BucketPermissionConfiguration.builder().applyMutation(permissionConfiguration)).build());
        }
    }
}

