/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.AssumedRole;
import software.amazon.awssdk.services.macie2.model.AwsAccount;
import software.amazon.awssdk.services.macie2.model.AwsService;
import software.amazon.awssdk.services.macie2.model.FederatedUser;
import software.amazon.awssdk.services.macie2.model.IamUser;
import software.amazon.awssdk.services.macie2.model.UserIdentityRoot;
import software.amazon.awssdk.services.macie2.model.UserIdentityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserIdentity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserIdentity> {
    private static final SdkField<AssumedRole> ASSUMED_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assumedRole").getter(UserIdentity.getter(UserIdentity::assumedRole)).setter(UserIdentity.setter(Builder::assumedRole)).constructor(AssumedRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assumedRole").build()}).build();
    private static final SdkField<AwsAccount> AWS_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsAccount").getter(UserIdentity.getter(UserIdentity::awsAccount)).setter(UserIdentity.setter(Builder::awsAccount)).constructor(AwsAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccount").build()}).build();
    private static final SdkField<AwsService> AWS_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsService").getter(UserIdentity.getter(UserIdentity::awsService)).setter(UserIdentity.setter(Builder::awsService)).constructor(AwsService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsService").build()}).build();
    private static final SdkField<FederatedUser> FEDERATED_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("federatedUser").getter(UserIdentity.getter(UserIdentity::federatedUser)).setter(UserIdentity.setter(Builder::federatedUser)).constructor(FederatedUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federatedUser").build()}).build();
    private static final SdkField<IamUser> IAM_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamUser").getter(UserIdentity.getter(UserIdentity::iamUser)).setter(UserIdentity.setter(Builder::iamUser)).constructor(IamUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamUser").build()}).build();
    private static final SdkField<UserIdentityRoot> ROOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("root").getter(UserIdentity.getter(UserIdentity::root)).setter(UserIdentity.setter(Builder::root)).constructor(UserIdentityRoot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("root").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UserIdentity.getter(UserIdentity::typeAsString)).setter(UserIdentity.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSUMED_ROLE_FIELD, AWS_ACCOUNT_FIELD, AWS_SERVICE_FIELD, FEDERATED_USER_FIELD, IAM_USER_FIELD, ROOT_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AssumedRole assumedRole;
    private final AwsAccount awsAccount;
    private final AwsService awsService;
    private final FederatedUser federatedUser;
    private final IamUser iamUser;
    private final UserIdentityRoot root;
    private final String type;

    private UserIdentity(BuilderImpl builder) {
        this.assumedRole = builder.assumedRole;
        this.awsAccount = builder.awsAccount;
        this.awsService = builder.awsService;
        this.federatedUser = builder.federatedUser;
        this.iamUser = builder.iamUser;
        this.root = builder.root;
        this.type = builder.type;
    }

    public AssumedRole assumedRole() {
        return this.assumedRole;
    }

    public AwsAccount awsAccount() {
        return this.awsAccount;
    }

    public AwsService awsService() {
        return this.awsService;
    }

    public FederatedUser federatedUser() {
        return this.federatedUser;
    }

    public IamUser iamUser() {
        return this.iamUser;
    }

    public UserIdentityRoot root() {
        return this.root;
    }

    public UserIdentityType type() {
        return UserIdentityType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assumedRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsService());
        hashCode = 31 * hashCode + Objects.hashCode(this.federatedUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.root());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentity)) {
            return false;
        }
        UserIdentity other = (UserIdentity)obj;
        return Objects.equals(this.assumedRole(), other.assumedRole()) && Objects.equals(this.awsAccount(), other.awsAccount()) && Objects.equals(this.awsService(), other.awsService()) && Objects.equals(this.federatedUser(), other.federatedUser()) && Objects.equals(this.iamUser(), other.iamUser()) && Objects.equals(this.root(), other.root()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UserIdentity").add("AssumedRole", (Object)this.assumedRole()).add("AwsAccount", (Object)this.awsAccount()).add("AwsService", (Object)this.awsService()).add("FederatedUser", (Object)this.federatedUser()).add("IamUser", (Object)this.iamUser()).add("Root", (Object)this.root()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assumedRole": {
                return Optional.ofNullable(clazz.cast(this.assumedRole()));
            }
            case "awsAccount": {
                return Optional.ofNullable(clazz.cast(this.awsAccount()));
            }
            case "awsService": {
                return Optional.ofNullable(clazz.cast(this.awsService()));
            }
            case "federatedUser": {
                return Optional.ofNullable(clazz.cast(this.federatedUser()));
            }
            case "iamUser": {
                return Optional.ofNullable(clazz.cast(this.iamUser()));
            }
            case "root": {
                return Optional.ofNullable(clazz.cast(this.root()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserIdentity, T> g) {
        return obj -> g.apply((UserIdentity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssumedRole assumedRole;
        private AwsAccount awsAccount;
        private AwsService awsService;
        private FederatedUser federatedUser;
        private IamUser iamUser;
        private UserIdentityRoot root;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdentity model) {
            this.assumedRole(model.assumedRole);
            this.awsAccount(model.awsAccount);
            this.awsService(model.awsService);
            this.federatedUser(model.federatedUser);
            this.iamUser(model.iamUser);
            this.root(model.root);
            this.type(model.type);
        }

        public final AssumedRole.Builder getAssumedRole() {
            return this.assumedRole != null ? this.assumedRole.toBuilder() : null;
        }

        @Override
        public final Builder assumedRole(AssumedRole assumedRole) {
            this.assumedRole = assumedRole;
            return this;
        }

        public final void setAssumedRole(AssumedRole.BuilderImpl assumedRole) {
            this.assumedRole = assumedRole != null ? assumedRole.build() : null;
        }

        public final AwsAccount.Builder getAwsAccount() {
            return this.awsAccount != null ? this.awsAccount.toBuilder() : null;
        }

        @Override
        public final Builder awsAccount(AwsAccount awsAccount) {
            this.awsAccount = awsAccount;
            return this;
        }

        public final void setAwsAccount(AwsAccount.BuilderImpl awsAccount) {
            this.awsAccount = awsAccount != null ? awsAccount.build() : null;
        }

        public final AwsService.Builder getAwsService() {
            return this.awsService != null ? this.awsService.toBuilder() : null;
        }

        @Override
        public final Builder awsService(AwsService awsService) {
            this.awsService = awsService;
            return this;
        }

        public final void setAwsService(AwsService.BuilderImpl awsService) {
            this.awsService = awsService != null ? awsService.build() : null;
        }

        public final FederatedUser.Builder getFederatedUser() {
            return this.federatedUser != null ? this.federatedUser.toBuilder() : null;
        }

        @Override
        public final Builder federatedUser(FederatedUser federatedUser) {
            this.federatedUser = federatedUser;
            return this;
        }

        public final void setFederatedUser(FederatedUser.BuilderImpl federatedUser) {
            this.federatedUser = federatedUser != null ? federatedUser.build() : null;
        }

        public final IamUser.Builder getIamUser() {
            return this.iamUser != null ? this.iamUser.toBuilder() : null;
        }

        @Override
        public final Builder iamUser(IamUser iamUser) {
            this.iamUser = iamUser;
            return this;
        }

        public final void setIamUser(IamUser.BuilderImpl iamUser) {
            this.iamUser = iamUser != null ? iamUser.build() : null;
        }

        public final UserIdentityRoot.Builder getRoot() {
            return this.root != null ? this.root.toBuilder() : null;
        }

        @Override
        public final Builder root(UserIdentityRoot root) {
            this.root = root;
            return this;
        }

        public final void setRoot(UserIdentityRoot.BuilderImpl root) {
            this.root = root != null ? root.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserIdentityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public UserIdentity build() {
            return new UserIdentity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserIdentity> {
        public Builder assumedRole(AssumedRole var1);

        default public Builder assumedRole(Consumer<AssumedRole.Builder> assumedRole) {
            return this.assumedRole((AssumedRole)((AssumedRole.Builder)AssumedRole.builder().applyMutation(assumedRole)).build());
        }

        public Builder awsAccount(AwsAccount var1);

        default public Builder awsAccount(Consumer<AwsAccount.Builder> awsAccount) {
            return this.awsAccount((AwsAccount)((AwsAccount.Builder)AwsAccount.builder().applyMutation(awsAccount)).build());
        }

        public Builder awsService(AwsService var1);

        default public Builder awsService(Consumer<AwsService.Builder> awsService) {
            return this.awsService((AwsService)((AwsService.Builder)AwsService.builder().applyMutation(awsService)).build());
        }

        public Builder federatedUser(FederatedUser var1);

        default public Builder federatedUser(Consumer<FederatedUser.Builder> federatedUser) {
            return this.federatedUser((FederatedUser)((FederatedUser.Builder)FederatedUser.builder().applyMutation(federatedUser)).build());
        }

        public Builder iamUser(IamUser var1);

        default public Builder iamUser(Consumer<IamUser.Builder> iamUser) {
            return this.iamUser((IamUser)((IamUser.Builder)IamUser.builder().applyMutation(iamUser)).build());
        }

        public Builder root(UserIdentityRoot var1);

        default public Builder root(Consumer<UserIdentityRoot.Builder> root) {
            return this.root((UserIdentityRoot)((UserIdentityRoot.Builder)UserIdentityRoot.builder().applyMutation(root)).build());
        }

        public Builder type(String var1);

        public Builder type(UserIdentityType var1);
    }
}

