/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Currency;
import software.amazon.awssdk.services.macie2.model.UsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageTotal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageTotal> {
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(UsageTotal.getter(UsageTotal::currencyAsString)).setter(UsageTotal.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<String> ESTIMATED_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("estimatedCost").getter(UsageTotal.getter(UsageTotal::estimatedCost)).setter(UsageTotal.setter(Builder::estimatedCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCost").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UsageTotal.getter(UsageTotal::typeAsString)).setter(UsageTotal.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_FIELD, ESTIMATED_COST_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currency;
    private final String estimatedCost;
    private final String type;

    private UsageTotal(BuilderImpl builder) {
        this.currency = builder.currency;
        this.estimatedCost = builder.estimatedCost;
        this.type = builder.type;
    }

    public Currency currency() {
        return Currency.fromValue(this.currency);
    }

    public String currencyAsString() {
        return this.currency;
    }

    public String estimatedCost() {
        return this.estimatedCost;
    }

    public UsageType type() {
        return UsageType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageTotal)) {
            return false;
        }
        UsageTotal other = (UsageTotal)obj;
        return Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.estimatedCost(), other.estimatedCost()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UsageTotal").add("Currency", (Object)this.currencyAsString()).add("EstimatedCost", (Object)this.estimatedCost()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "estimatedCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedCost()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageTotal, T> g) {
        return obj -> g.apply((UsageTotal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currency;
        private String estimatedCost;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageTotal model) {
            this.currency(model.currency);
            this.estimatedCost(model.estimatedCost);
            this.type(model.type);
        }

        public final String getCurrency() {
            return this.currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(Currency currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        public final String getEstimatedCost() {
            return this.estimatedCost;
        }

        @Override
        public final Builder estimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
            return this;
        }

        public final void setEstimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UsageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public UsageTotal build() {
            return new UsageTotal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageTotal> {
        public Builder currency(String var1);

        public Builder currency(Currency var1);

        public Builder estimatedCost(String var1);

        public Builder type(String var1);

        public Builder type(UsageType var1);
    }
}

