/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.AccessControlList;
import software.amazon.awssdk.services.macie2.model.BlockPublicAccess;
import software.amazon.awssdk.services.macie2.model.BucketPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketLevelPermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketLevelPermissions> {
    private static final SdkField<AccessControlList> ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessControlList").getter(BucketLevelPermissions.getter(BucketLevelPermissions::accessControlList)).setter(BucketLevelPermissions.setter(Builder::accessControlList)).constructor(AccessControlList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessControlList").build()}).build();
    private static final SdkField<BlockPublicAccess> BLOCK_PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("blockPublicAccess").getter(BucketLevelPermissions.getter(BucketLevelPermissions::blockPublicAccess)).setter(BucketLevelPermissions.setter(Builder::blockPublicAccess)).constructor(BlockPublicAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockPublicAccess").build()}).build();
    private static final SdkField<BucketPolicy> BUCKET_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bucketPolicy").getter(BucketLevelPermissions.getter(BucketLevelPermissions::bucketPolicy)).setter(BucketLevelPermissions.setter(Builder::bucketPolicy)).constructor(BucketPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_LIST_FIELD, BLOCK_PUBLIC_ACCESS_FIELD, BUCKET_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccessControlList accessControlList;
    private final BlockPublicAccess blockPublicAccess;
    private final BucketPolicy bucketPolicy;

    private BucketLevelPermissions(BuilderImpl builder) {
        this.accessControlList = builder.accessControlList;
        this.blockPublicAccess = builder.blockPublicAccess;
        this.bucketPolicy = builder.bucketPolicy;
    }

    public AccessControlList accessControlList() {
        return this.accessControlList;
    }

    public BlockPublicAccess blockPublicAccess() {
        return this.blockPublicAccess;
    }

    public BucketPolicy bucketPolicy() {
        return this.bucketPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControlList());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockPublicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPolicy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketLevelPermissions)) {
            return false;
        }
        BucketLevelPermissions other = (BucketLevelPermissions)obj;
        return Objects.equals(this.accessControlList(), other.accessControlList()) && Objects.equals(this.blockPublicAccess(), other.blockPublicAccess()) && Objects.equals(this.bucketPolicy(), other.bucketPolicy());
    }

    public String toString() {
        return ToString.builder((String)"BucketLevelPermissions").add("AccessControlList", (Object)this.accessControlList()).add("BlockPublicAccess", (Object)this.blockPublicAccess()).add("BucketPolicy", (Object)this.bucketPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessControlList": {
                return Optional.ofNullable(clazz.cast(this.accessControlList()));
            }
            case "blockPublicAccess": {
                return Optional.ofNullable(clazz.cast(this.blockPublicAccess()));
            }
            case "bucketPolicy": {
                return Optional.ofNullable(clazz.cast(this.bucketPolicy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketLevelPermissions, T> g) {
        return obj -> g.apply((BucketLevelPermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccessControlList accessControlList;
        private BlockPublicAccess blockPublicAccess;
        private BucketPolicy bucketPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketLevelPermissions model) {
            this.accessControlList(model.accessControlList);
            this.blockPublicAccess(model.blockPublicAccess);
            this.bucketPolicy(model.bucketPolicy);
        }

        public final AccessControlList.Builder getAccessControlList() {
            return this.accessControlList != null ? this.accessControlList.toBuilder() : null;
        }

        @Override
        public final Builder accessControlList(AccessControlList accessControlList) {
            this.accessControlList = accessControlList;
            return this;
        }

        public final void setAccessControlList(AccessControlList.BuilderImpl accessControlList) {
            this.accessControlList = accessControlList != null ? accessControlList.build() : null;
        }

        public final BlockPublicAccess.Builder getBlockPublicAccess() {
            return this.blockPublicAccess != null ? this.blockPublicAccess.toBuilder() : null;
        }

        @Override
        public final Builder blockPublicAccess(BlockPublicAccess blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess;
            return this;
        }

        public final void setBlockPublicAccess(BlockPublicAccess.BuilderImpl blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess != null ? blockPublicAccess.build() : null;
        }

        public final BucketPolicy.Builder getBucketPolicy() {
            return this.bucketPolicy != null ? this.bucketPolicy.toBuilder() : null;
        }

        @Override
        public final Builder bucketPolicy(BucketPolicy bucketPolicy) {
            this.bucketPolicy = bucketPolicy;
            return this;
        }

        public final void setBucketPolicy(BucketPolicy.BuilderImpl bucketPolicy) {
            this.bucketPolicy = bucketPolicy != null ? bucketPolicy.build() : null;
        }

        public BucketLevelPermissions build() {
            return new BucketLevelPermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketLevelPermissions> {
        public Builder accessControlList(AccessControlList var1);

        default public Builder accessControlList(Consumer<AccessControlList.Builder> accessControlList) {
            return this.accessControlList((AccessControlList)((AccessControlList.Builder)AccessControlList.builder().applyMutation(accessControlList)).build());
        }

        public Builder blockPublicAccess(BlockPublicAccess var1);

        default public Builder blockPublicAccess(Consumer<BlockPublicAccess.Builder> blockPublicAccess) {
            return this.blockPublicAccess((BlockPublicAccess)((BlockPublicAccess.Builder)BlockPublicAccess.builder().applyMutation(blockPublicAccess)).build());
        }

        public Builder bucketPolicy(BucketPolicy var1);

        default public Builder bucketPolicy(Consumer<BucketPolicy.Builder> bucketPolicy) {
            return this.bucketPolicy((BucketPolicy)((BucketPolicy.Builder)BucketPolicy.builder().applyMutation(bucketPolicy)).build());
        }
    }
}

