/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.UsageRecord;

public class GetUsageStatisticsIterable
implements SdkIterable<GetUsageStatisticsResponse> {
    private final Macie2Client client;
    private final GetUsageStatisticsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetUsageStatisticsIterable(Macie2Client client, GetUsageStatisticsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetUsageStatisticsResponseFetcher();
    }

    public Iterator<GetUsageStatisticsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UsageRecord> records() {
        Function<GetUsageStatisticsResponse, Iterator> getIterator = response -> {
            if (response != null && response.records() != null) {
                return response.records().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetUsageStatisticsResponseFetcher
    implements SyncPageFetcher<GetUsageStatisticsResponse> {
        private GetUsageStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(GetUsageStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetUsageStatisticsResponse nextPage(GetUsageStatisticsResponse previousPage) {
            if (previousPage == null) {
                return GetUsageStatisticsIterable.this.client.getUsageStatistics(GetUsageStatisticsIterable.this.firstRequest);
            }
            return GetUsageStatisticsIterable.this.client.getUsageStatistics((GetUsageStatisticsRequest)((Object)GetUsageStatisticsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

