/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.TagMapCopier;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomDataIdentifierRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, CreateCustomDataIdentifierRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCustomDataIdentifierRequest.getter(CreateCustomDataIdentifierRequest::clientToken)).setter(CreateCustomDataIdentifierRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCustomDataIdentifierRequest.getter(CreateCustomDataIdentifierRequest::description)).setter(CreateCustomDataIdentifierRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> IGNORE_WORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCustomDataIdentifierRequest.getter(CreateCustomDataIdentifierRequest::ignoreWords)).setter(CreateCustomDataIdentifierRequest.setter(Builder::ignoreWords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreWords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCustomDataIdentifierRequest.getter(CreateCustomDataIdentifierRequest::keywords)).setter(CreateCustomDataIdentifierRequest.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAXIMUM_MATCH_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateCustomDataIdentifierRequest.getter(CreateCustomDataIdentifierRequest::maximumMatchDistance)).setter(CreateCustomDataIdentifierRequest.setter(Builder::maximumMatchDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMatchDistance").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCustomDataIdentifierRequest.getter(CreateCustomDataIdentifierRequest::name)).setter(CreateCustomDataIdentifierRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REGEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCustomDataIdentifierRequest.getter(CreateCustomDataIdentifierRequest::regex)).setter(CreateCustomDataIdentifierRequest.setter(Builder::regex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateCustomDataIdentifierRequest.getter(CreateCustomDataIdentifierRequest::tags)).setter(CreateCustomDataIdentifierRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, IGNORE_WORDS_FIELD, KEYWORDS_FIELD, MAXIMUM_MATCH_DISTANCE_FIELD, NAME_FIELD, REGEX_FIELD, TAGS_FIELD));
    private final String clientToken;
    private final String description;
    private final List<String> ignoreWords;
    private final List<String> keywords;
    private final Integer maximumMatchDistance;
    private final String name;
    private final String regex;
    private final Map<String, String> tags;

    private CreateCustomDataIdentifierRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.ignoreWords = builder.ignoreWords;
        this.keywords = builder.keywords;
        this.maximumMatchDistance = builder.maximumMatchDistance;
        this.name = builder.name;
        this.regex = builder.regex;
        this.tags = builder.tags;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String description() {
        return this.description;
    }

    public boolean hasIgnoreWords() {
        return this.ignoreWords != null && !(this.ignoreWords instanceof SdkAutoConstructList);
    }

    public List<String> ignoreWords() {
        return this.ignoreWords;
    }

    public boolean hasKeywords() {
        return this.keywords != null && !(this.keywords instanceof SdkAutoConstructList);
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public Integer maximumMatchDistance() {
        return this.maximumMatchDistance;
    }

    public String name() {
        return this.name;
    }

    public String regex() {
        return this.regex;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreWords());
        hashCode = 31 * hashCode + Objects.hashCode(this.keywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMatchDistance());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.regex());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomDataIdentifierRequest)) {
            return false;
        }
        CreateCustomDataIdentifierRequest other = (CreateCustomDataIdentifierRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ignoreWords(), other.ignoreWords()) && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.maximumMatchDistance(), other.maximumMatchDistance()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.regex(), other.regex()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateCustomDataIdentifierRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("IgnoreWords", this.ignoreWords()).add("Keywords", this.keywords()).add("MaximumMatchDistance", (Object)this.maximumMatchDistance()).add("Name", (Object)this.name()).add("Regex", (Object)this.regex()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ignoreWords": {
                return Optional.ofNullable(clazz.cast(this.ignoreWords()));
            }
            case "keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "maximumMatchDistance": {
                return Optional.ofNullable(clazz.cast(this.maximumMatchDistance()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "regex": {
                return Optional.ofNullable(clazz.cast(this.regex()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomDataIdentifierRequest, T> g) {
        return obj -> g.apply((CreateCustomDataIdentifierRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private List<String> ignoreWords = DefaultSdkAutoConstructList.getInstance();
        private List<String> keywords = DefaultSdkAutoConstructList.getInstance();
        private Integer maximumMatchDistance;
        private String name;
        private String regex;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomDataIdentifierRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.ignoreWords(model.ignoreWords);
            this.keywords(model.keywords);
            this.maximumMatchDistance(model.maximumMatchDistance);
            this.name(model.name);
            this.regex(model.regex);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getIgnoreWords() {
            return this.ignoreWords;
        }

        @Override
        public final Builder ignoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ignoreWords(String ... ignoreWords) {
            this.ignoreWords(Arrays.asList(ignoreWords));
            return this;
        }

        public final void setIgnoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
        }

        public final Collection<String> getKeywords() {
            return this.keywords;
        }

        @Override
        public final Builder keywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(String ... keywords) {
            this.keywords(Arrays.asList(keywords));
            return this;
        }

        public final void setKeywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
        }

        public final Integer getMaximumMatchDistance() {
            return this.maximumMatchDistance;
        }

        @Override
        public final Builder maximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
            return this;
        }

        public final void setMaximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegex() {
            return this.regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomDataIdentifierRequest build() {
            return new CreateCustomDataIdentifierRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomDataIdentifierRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder ignoreWords(Collection<String> var1);

        public Builder ignoreWords(String ... var1);

        public Builder keywords(Collection<String> var1);

        public Builder keywords(String ... var1);

        public Builder maximumMatchDistance(Integer var1);

        public Builder name(String var1);

        public Builder regex(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

