/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterComparator;
import software.amazon.awssdk.services.macie2.model.UsageStatisticsFilterKey;
import software.amazon.awssdk.services.macie2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageStatisticsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageStatisticsFilter> {
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageStatisticsFilter.getter(UsageStatisticsFilter::comparatorAsString)).setter(UsageStatisticsFilter.setter(Builder::comparator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageStatisticsFilter.getter(UsageStatisticsFilter::keyAsString)).setter(UsageStatisticsFilter.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UsageStatisticsFilter.getter(UsageStatisticsFilter::values)).setter(UsageStatisticsFilter.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARATOR_FIELD, KEY_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comparator;
    private final String key;
    private final List<String> values;

    private UsageStatisticsFilter(BuilderImpl builder) {
        this.comparator = builder.comparator;
        this.key = builder.key;
        this.values = builder.values;
    }

    public UsageStatisticsFilterComparator comparator() {
        return UsageStatisticsFilterComparator.fromValue(this.comparator);
    }

    public String comparatorAsString() {
        return this.comparator;
    }

    public UsageStatisticsFilterKey key() {
        return UsageStatisticsFilterKey.fromValue(this.key);
    }

    public String keyAsString() {
        return this.key;
    }

    public boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageStatisticsFilter)) {
            return false;
        }
        UsageStatisticsFilter other = (UsageStatisticsFilter)obj;
        return Objects.equals(this.comparatorAsString(), other.comparatorAsString()) && Objects.equals(this.keyAsString(), other.keyAsString()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"UsageStatisticsFilter").add("Comparator", (Object)this.comparatorAsString()).add("Key", (Object)this.keyAsString()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comparator": {
                return Optional.ofNullable(clazz.cast(this.comparatorAsString()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.keyAsString()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageStatisticsFilter, T> g) {
        return obj -> g.apply((UsageStatisticsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparator;
        private String key;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageStatisticsFilter model) {
            this.comparator(model.comparator);
            this.key(model.key);
            this.values(model.values);
        }

        public final String getComparator() {
            return this.comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(UsageStatisticsFilterComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(UsageStatisticsFilterKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
        }

        public UsageStatisticsFilter build() {
            return new UsageStatisticsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageStatisticsFilter> {
        public Builder comparator(String var1);

        public Builder comparator(UsageStatisticsFilterComparator var1);

        public Builder key(String var1);

        public Builder key(UsageStatisticsFilterKey var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

