/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.Currency;
import software.amazon.awssdk.services.macie2.model.ServiceLimit;
import software.amazon.awssdk.services.macie2.model.UsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageByAccount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageByAccount> {
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageByAccount.getter(UsageByAccount::currencyAsString)).setter(UsageByAccount.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<String> ESTIMATED_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageByAccount.getter(UsageByAccount::estimatedCost)).setter(UsageByAccount.setter(Builder::estimatedCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCost").build()}).build();
    private static final SdkField<ServiceLimit> SERVICE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UsageByAccount.getter(UsageByAccount::serviceLimit)).setter(UsageByAccount.setter(Builder::serviceLimit)).constructor(ServiceLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceLimit").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageByAccount.getter(UsageByAccount::typeAsString)).setter(UsageByAccount.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_FIELD, ESTIMATED_COST_FIELD, SERVICE_LIMIT_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currency;
    private final String estimatedCost;
    private final ServiceLimit serviceLimit;
    private final String type;

    private UsageByAccount(BuilderImpl builder) {
        this.currency = builder.currency;
        this.estimatedCost = builder.estimatedCost;
        this.serviceLimit = builder.serviceLimit;
        this.type = builder.type;
    }

    public Currency currency() {
        return Currency.fromValue(this.currency);
    }

    public String currencyAsString() {
        return this.currency;
    }

    public String estimatedCost() {
        return this.estimatedCost;
    }

    public ServiceLimit serviceLimit() {
        return this.serviceLimit;
    }

    public UsageType type() {
        return UsageType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageByAccount)) {
            return false;
        }
        UsageByAccount other = (UsageByAccount)obj;
        return Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.estimatedCost(), other.estimatedCost()) && Objects.equals(this.serviceLimit(), other.serviceLimit()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UsageByAccount").add("Currency", (Object)this.currencyAsString()).add("EstimatedCost", (Object)this.estimatedCost()).add("ServiceLimit", (Object)this.serviceLimit()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "estimatedCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedCost()));
            }
            case "serviceLimit": {
                return Optional.ofNullable(clazz.cast(this.serviceLimit()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageByAccount, T> g) {
        return obj -> g.apply((UsageByAccount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currency;
        private String estimatedCost;
        private ServiceLimit serviceLimit;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageByAccount model) {
            this.currency(model.currency);
            this.estimatedCost(model.estimatedCost);
            this.serviceLimit(model.serviceLimit);
            this.type(model.type);
        }

        public final String getCurrency() {
            return this.currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(Currency currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        public final String getEstimatedCost() {
            return this.estimatedCost;
        }

        @Override
        public final Builder estimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
            return this;
        }

        public final void setEstimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
        }

        public final ServiceLimit.Builder getServiceLimit() {
            return this.serviceLimit != null ? this.serviceLimit.toBuilder() : null;
        }

        @Override
        public final Builder serviceLimit(ServiceLimit serviceLimit) {
            this.serviceLimit = serviceLimit;
            return this;
        }

        public final void setServiceLimit(ServiceLimit.BuilderImpl serviceLimit) {
            this.serviceLimit = serviceLimit != null ? serviceLimit.build() : null;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UsageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public UsageByAccount build() {
            return new UsageByAccount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageByAccount> {
        public Builder currency(String var1);

        public Builder currency(Currency var1);

        public Builder estimatedCost(String var1);

        public Builder serviceLimit(ServiceLimit var1);

        default public Builder serviceLimit(Consumer<ServiceLimit.Builder> serviceLimit) {
            return this.serviceLimit((ServiceLimit)((ServiceLimit.Builder)ServiceLimit.builder().applyMutation(serviceLimit)).build());
        }

        public Builder type(String var1);

        public Builder type(UsageType var1);
    }
}

