/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.AccountLevelPermissions;
import software.amazon.awssdk.services.macie2.model.BucketLevelPermissions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketPermissionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketPermissionConfiguration> {
    private static final SdkField<AccountLevelPermissions> ACCOUNT_LEVEL_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BucketPermissionConfiguration.getter(BucketPermissionConfiguration::accountLevelPermissions)).setter(BucketPermissionConfiguration.setter(Builder::accountLevelPermissions)).constructor(AccountLevelPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountLevelPermissions").build()}).build();
    private static final SdkField<BucketLevelPermissions> BUCKET_LEVEL_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BucketPermissionConfiguration.getter(BucketPermissionConfiguration::bucketLevelPermissions)).setter(BucketPermissionConfiguration.setter(Builder::bucketLevelPermissions)).constructor(BucketLevelPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketLevelPermissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_LEVEL_PERMISSIONS_FIELD, BUCKET_LEVEL_PERMISSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccountLevelPermissions accountLevelPermissions;
    private final BucketLevelPermissions bucketLevelPermissions;

    private BucketPermissionConfiguration(BuilderImpl builder) {
        this.accountLevelPermissions = builder.accountLevelPermissions;
        this.bucketLevelPermissions = builder.bucketLevelPermissions;
    }

    public AccountLevelPermissions accountLevelPermissions() {
        return this.accountLevelPermissions;
    }

    public BucketLevelPermissions bucketLevelPermissions() {
        return this.bucketLevelPermissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountLevelPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketLevelPermissions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketPermissionConfiguration)) {
            return false;
        }
        BucketPermissionConfiguration other = (BucketPermissionConfiguration)obj;
        return Objects.equals(this.accountLevelPermissions(), other.accountLevelPermissions()) && Objects.equals(this.bucketLevelPermissions(), other.bucketLevelPermissions());
    }

    public String toString() {
        return ToString.builder((String)"BucketPermissionConfiguration").add("AccountLevelPermissions", (Object)this.accountLevelPermissions()).add("BucketLevelPermissions", (Object)this.bucketLevelPermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountLevelPermissions": {
                return Optional.ofNullable(clazz.cast(this.accountLevelPermissions()));
            }
            case "bucketLevelPermissions": {
                return Optional.ofNullable(clazz.cast(this.bucketLevelPermissions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketPermissionConfiguration, T> g) {
        return obj -> g.apply((BucketPermissionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccountLevelPermissions accountLevelPermissions;
        private BucketLevelPermissions bucketLevelPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketPermissionConfiguration model) {
            this.accountLevelPermissions(model.accountLevelPermissions);
            this.bucketLevelPermissions(model.bucketLevelPermissions);
        }

        public final AccountLevelPermissions.Builder getAccountLevelPermissions() {
            return this.accountLevelPermissions != null ? this.accountLevelPermissions.toBuilder() : null;
        }

        @Override
        public final Builder accountLevelPermissions(AccountLevelPermissions accountLevelPermissions) {
            this.accountLevelPermissions = accountLevelPermissions;
            return this;
        }

        public final void setAccountLevelPermissions(AccountLevelPermissions.BuilderImpl accountLevelPermissions) {
            this.accountLevelPermissions = accountLevelPermissions != null ? accountLevelPermissions.build() : null;
        }

        public final BucketLevelPermissions.Builder getBucketLevelPermissions() {
            return this.bucketLevelPermissions != null ? this.bucketLevelPermissions.toBuilder() : null;
        }

        @Override
        public final Builder bucketLevelPermissions(BucketLevelPermissions bucketLevelPermissions) {
            this.bucketLevelPermissions = bucketLevelPermissions;
            return this;
        }

        public final void setBucketLevelPermissions(BucketLevelPermissions.BuilderImpl bucketLevelPermissions) {
            this.bucketLevelPermissions = bucketLevelPermissions != null ? bucketLevelPermissions.build() : null;
        }

        public BucketPermissionConfiguration build() {
            return new BucketPermissionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketPermissionConfiguration> {
        public Builder accountLevelPermissions(AccountLevelPermissions var1);

        default public Builder accountLevelPermissions(Consumer<AccountLevelPermissions.Builder> accountLevelPermissions) {
            return this.accountLevelPermissions((AccountLevelPermissions)((AccountLevelPermissions.Builder)AccountLevelPermissions.builder().applyMutation(accountLevelPermissions)).build());
        }

        public Builder bucketLevelPermissions(BucketLevelPermissions var1);

        default public Builder bucketLevelPermissions(Consumer<BucketLevelPermissions.Builder> bucketLevelPermissions) {
            return this.bucketLevelPermissions((BucketLevelPermissions)((BucketLevelPermissions.Builder)BucketLevelPermissions.builder().applyMutation(bucketLevelPermissions)).build());
        }
    }
}

