/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class FailedS3ResourcesCopier {
    static List<FailedS3Resource> copy(Collection<FailedS3Resource> failedS3ResourcesParam) {
        if (failedS3ResourcesParam == null || failedS3ResourcesParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<FailedS3Resource> failedS3ResourcesParamCopy = new ArrayList<>(failedS3ResourcesParam);
        return Collections.unmodifiableList(failedS3ResourcesParamCopy);
    }

    static List<FailedS3Resource> copyFromBuilder(Collection<? extends FailedS3Resource.Builder> failedS3ResourcesParam) {
        if (failedS3ResourcesParam == null || failedS3ResourcesParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(failedS3ResourcesParam.stream().map(FailedS3Resource.Builder::build).collect(toList()));
    }
}
