/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.services.machinelearning.model.TaggableResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteTagsResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, DeleteTagsResponse> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteTagsResponse.getter(DeleteTagsResponse::resourceId)).setter(DeleteTagsResponse.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteTagsResponse.getter(DeleteTagsResponse::resourceTypeAsString)).setter(DeleteTagsResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));
    private final String resourceId;
    private final String resourceType;

    private DeleteTagsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public TaggableResourceType resourceType() {
        return TaggableResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsResponse)) {
            return false;
        }
        DeleteTagsResponse other = (DeleteTagsResponse)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DeleteTagsResponse").add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTagsResponse, T> g) {
        return obj -> g.apply((DeleteTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsResponse model) {
            super(model);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TaggableResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public DeleteTagsResponse build() {
            return new DeleteTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteTagsResponse> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TaggableResourceType var1);
    }
}

