/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RealtimeEndpointInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RealtimeEndpointInfo> {
    private static final SdkField<Integer> PEAK_REQUESTS_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeakRequestsPerSecond").getter(RealtimeEndpointInfo.getter(RealtimeEndpointInfo::peakRequestsPerSecond)).setter(RealtimeEndpointInfo.setter(Builder::peakRequestsPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeakRequestsPerSecond").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(RealtimeEndpointInfo.getter(RealtimeEndpointInfo::createdAt)).setter(RealtimeEndpointInfo.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointUrl").getter(RealtimeEndpointInfo.getter(RealtimeEndpointInfo::endpointUrl)).setter(RealtimeEndpointInfo.setter(Builder::endpointUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()}).build();
    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointStatus").getter(RealtimeEndpointInfo.getter(RealtimeEndpointInfo::endpointStatusAsString)).setter(RealtimeEndpointInfo.setter(Builder::endpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEAK_REQUESTS_PER_SECOND_FIELD, CREATED_AT_FIELD, ENDPOINT_URL_FIELD, ENDPOINT_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer peakRequestsPerSecond;
    private final Instant createdAt;
    private final String endpointUrl;
    private final String endpointStatus;

    private RealtimeEndpointInfo(BuilderImpl builder) {
        this.peakRequestsPerSecond = builder.peakRequestsPerSecond;
        this.createdAt = builder.createdAt;
        this.endpointUrl = builder.endpointUrl;
        this.endpointStatus = builder.endpointStatus;
    }

    public final Integer peakRequestsPerSecond() {
        return this.peakRequestsPerSecond;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String endpointUrl() {
        return this.endpointUrl;
    }

    public final RealtimeEndpointStatus endpointStatus() {
        return RealtimeEndpointStatus.fromValue(this.endpointStatus);
    }

    public final String endpointStatusAsString() {
        return this.endpointStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.peakRequestsPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeEndpointInfo)) {
            return false;
        }
        RealtimeEndpointInfo other = (RealtimeEndpointInfo)obj;
        return Objects.equals(this.peakRequestsPerSecond(), other.peakRequestsPerSecond()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.endpointUrl(), other.endpointUrl()) && Objects.equals(this.endpointStatusAsString(), other.endpointStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RealtimeEndpointInfo").add("PeakRequestsPerSecond", (Object)this.peakRequestsPerSecond()).add("CreatedAt", (Object)this.createdAt()).add("EndpointUrl", (Object)this.endpointUrl()).add("EndpointStatus", (Object)this.endpointStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PeakRequestsPerSecond": {
                return Optional.ofNullable(clazz.cast(this.peakRequestsPerSecond()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "EndpointUrl": {
                return Optional.ofNullable(clazz.cast(this.endpointUrl()));
            }
            case "EndpointStatus": {
                return Optional.ofNullable(clazz.cast(this.endpointStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealtimeEndpointInfo, T> g) {
        return obj -> g.apply((RealtimeEndpointInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer peakRequestsPerSecond;
        private Instant createdAt;
        private String endpointUrl;
        private String endpointStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeEndpointInfo model) {
            this.peakRequestsPerSecond(model.peakRequestsPerSecond);
            this.createdAt(model.createdAt);
            this.endpointUrl(model.endpointUrl);
            this.endpointStatus(model.endpointStatus);
        }

        public final Integer getPeakRequestsPerSecond() {
            return this.peakRequestsPerSecond;
        }

        public final void setPeakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
        }

        @Override
        @Transient
        public final Builder peakRequestsPerSecond(Integer peakRequestsPerSecond) {
            this.peakRequestsPerSecond = peakRequestsPerSecond;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getEndpointUrl() {
            return this.endpointUrl;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        @Override
        @Transient
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        @Transient
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder endpointStatus(RealtimeEndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus == null ? null : endpointStatus.toString());
            return this;
        }

        public RealtimeEndpointInfo build() {
            return new RealtimeEndpointInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RealtimeEndpointInfo> {
        public Builder peakRequestsPerSecond(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder endpointUrl(String var1);

        public Builder endpointStatus(String var1);

        public Builder endpointStatus(RealtimeEndpointStatus var1);
    }
}

